/*
 * Decompiled with CFR 0.152.
 */
package score.model.specification;

import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;
import score.api.dto.requestdto.ScoreDetailQueryDTO;

public class ScoreDetailSpecification<T>
implements Specification<T> {
    private ScoreDetailQueryDTO scoreDetailQueryDTO;

    public ScoreDetailSpecification(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        this.scoreDetailQueryDTO = scoreDetailQueryDTO;
    }

    public ScoreDetailSpecification() {
    }

    public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
        Predicate predicate = cb.equal((Expression)root.get("scoreAccount").get("organizationCode"), (Object)this.scoreDetailQueryDTO.getOrganizationCode());
        if (!StringUtils.isEmpty((Object)this.scoreDetailQueryDTO.getScoreAccountIds()) && !this.scoreDetailQueryDTO.getScoreAccountIds().isEmpty()) {
            predicate = cb.and(new Predicate[]{root.get("scoreAccount").get("id").in((Collection)this.scoreDetailQueryDTO.getScoreAccountIds())});
        }
        if (!StringUtils.isEmpty((Object)this.scoreDetailQueryDTO.getBusiCode())) {
            predicate = cb.and((Expression)predicate, (Expression)cb.equal((Expression)root.get("busiCode"), (Object)this.scoreDetailQueryDTO.getBusiCode()));
        }
        if (this.scoreDetailQueryDTO.getStartDate() != null) {
            predicate = cb.and((Expression)predicate, (Expression)cb.greaterThanOrEqualTo((Expression)root.get("transaTime"), (Comparable)this.scoreDetailQueryDTO.getStartDate()));
        }
        if (this.scoreDetailQueryDTO.getEndDate() != null) {
            predicate = cb.and((Expression)predicate, (Expression)cb.lessThanOrEqualTo((Expression)root.get("transaTime"), (Comparable)this.scoreDetailQueryDTO.getEndDate()));
        }
        if (!StringUtils.isEmpty((Object)this.scoreDetailQueryDTO.getNickName())) {
            predicate = cb.and((Expression)predicate, (Expression)cb.like((Expression)root.get("scoreAccount").get("nickName"), "%" + this.scoreDetailQueryDTO.getNickName() + "%"));
        }
        return predicate;
    }
}

