package score.service.apiimpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import score.api.OrganizationScoreApi;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.OrgPersonScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.api.exception.BatchAddScoreException;
import score.service.service.OrganizationScoreService;
import sinomall.config.api.base.BaseResponse;
import utils.GlobalContants;

import java.util.List;

@MotanService
public class OrganizationScoreApiImpl implements OrganizationScoreApi {
    @Autowired
    OrganizationScoreService organizationScoreService;

    @Override
    public PageResponseDTO<ScoreIncomeDetailDTO> queryAllScoreIncomeDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO) {
        return organizationScoreService.queryAllScoreIncomeDetails(orgPersonScoreDetailQueryDTO);
    }

    @Override
    public PageResponseDTO<ScoreExpenseDetailDTO> queryAllScoreExpenseDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO) {
        return organizationScoreService.queryAllScoreExpenseDetails(orgPersonScoreDetailQueryDTO);
    }

    @Override
    public List<TransactionResponseDTO> batchAddScore(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailDTOs) {
        return organizationScoreService.batchAddScore(scoreIncomeDetailDTOs);
    }

    @Override
    public BaseResponse batchAddScoreAll(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailDTOs) {
        try {
            return organizationScoreService.batchAddScoreAll(scoreIncomeDetailDTOs);
        } catch (BatchAddScoreException e) {
            return new BaseResponse(GlobalContants.ResponseStatus.ERROR, e.getMessage());
        }
    }
}
