package score.service.apiimpl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import score.api.ScoreApi;
import score.api.dto.entitydto.*;
import score.api.dto.requestdto.*;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.api.exception.GiveAwayFailException;
import score.service.service.ScoreLockService;
import score.service.service.ScoreService;
import sinomall.config.api.base.BaseResponse;
import utils.GlobalContants;
import utils.lock.RedisLockUtil;

@MotanService
public class ScoreApiImpl implements ScoreApi {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    ScoreService scoreService;
    @Autowired
    ScoreLockService scoreLockService;
    @Autowired
    RedisLockUtil redisLockUtil;

    @Override
    public ScoreAccountDTO queryScoreAccount(ScoreAccountRequestDTO scoreAccountRequestDTO) {
        //查询创建账户防止并发
        try {
            redisLockUtil.lock(SCORE_CREATE_LOCK_PREFIX);
            return scoreService.queryScoreAccount(scoreAccountRequestDTO);
        } catch (Exception e) {
            throw e;
        } finally {
            redisLockUtil.unlock(SCORE_CREATE_LOCK_PREFIX);
        }
    }

    @Override
    public TransactionResponseDTO addScore(ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO) {
        //需要在外层做锁，确保事务已提交
        try {
            redisLockUtil.lock(SCORE_LOCK_PREFIX + scoreIncomeDetailRequestDTO.getScoreAccountId());
            return scoreService.addScore(scoreIncomeDetailRequestDTO);
        } catch (Exception e) {
            throw e;
        } finally {
            // TODO: 2017-11-14 锁并发
            redisLockUtil.unlock(SCORE_LOCK_PREFIX + scoreIncomeDetailRequestDTO.getScoreAccountId());
        }
    }

    @Override
    public TransactionResponseDTO expenseScore(ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO) {
        try {
            redisLockUtil.lock(SCORE_LOCK_PREFIX + scoreExpenseDetailRequestDTO.getScoreAccountId());
            return scoreService.expenseScore(scoreExpenseDetailRequestDTO);
        } catch (Exception e) {
            throw e;
        } finally {
            // TODO: 2017-11-14 锁并发
            redisLockUtil.unlock(SCORE_LOCK_PREFIX + scoreExpenseDetailRequestDTO.getScoreAccountId());
        }
    }

    @Override
    public PageResponseDTO<ScoreIncomeDetailDTO> queryScoreIncomeDetais(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        return scoreService.queryScoreIncomeDetais(scoreDetailQueryDTO);
    }

    @Override
    public PageResponseDTO<ScoreExpenseDetailDTO> queryScoreExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        return scoreService.queryScoreExpenseDetails(scoreDetailQueryDTO);
    }

    /**
     * 个人查询收入支出明细api
     *
     * @param scoreDetailQueryDTO
     * @return
     */
    @Override
    public PageResponseDTO<ScoreIncomeExpenseDetailDTO> queryScoreIncomeExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        return scoreService.queryScoreIncomeExpenseDetails(scoreDetailQueryDTO);
    }

    @Override
    public ScoreGiveAwayLogDTO scoreGiveAway(ScoreGiveAwayRequestDTO scoreGiveAwayRequestDTO) {
        ScoreGiveAwayLogDTO scoreGiveAwayLogDTO = new ScoreGiveAwayLogDTO();
        scoreGiveAwayLogDTO.setStatus(GlobalContants.ResponseStatus.ERROR);
        scoreGiveAwayLogDTO.setResponseMsg("赠送积分失败");
        try {
            scoreGiveAwayLogDTO = scoreService.scoreGiveAway(scoreGiveAwayRequestDTO);
        } catch (GiveAwayFailException e) {
            logger.error("赠送积分失败", e);
            if (!StringUtils.isEmpty(e.getMessage())) {
                scoreGiveAwayLogDTO = JSON.parseObject(e.getMessage(), ScoreGiveAwayLogDTO.class);
            }
        }
        return scoreGiveAwayLogDTO;
    }

    @Override
    public ScoreGiveAwayLogDTO getScoreGiveAwayInfo(GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO) {
        return scoreService.getScoreGiveAwayInfo(getScoreGiveAwayInfoRequestDTO);
    }

    @Override
    public ScoreStatisticsResponseDTO scoreIncomeStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO) {
        return scoreService.scoreIncomeStatics(scoreStatisticsRequestDTO);
    }

    @Override
    public ScoreStatisticsResponseDTO scoreExpenseStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO) {
        return scoreService.scoreExpenseStatics(scoreStatisticsRequestDTO);
    }

    @Override
    public BaseResponse deleteAccount(String scoreAccountId) {
        return scoreService.deleteAccount(scoreAccountId);
    }
}
