package score.service.service;

import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.OrgPersonScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import sinomall.config.api.base.BaseResponse;

import java.util.List;

public interface OrganizationScoreService {
    /**
     * 企业批增积分，单笔持久化出错不需回滚，无须全部导入
     *
     * @param scoreIncomeDetailDTOs
     * @return
     */
    public List<TransactionResponseDTO> batchAddScore(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailDTOs);

    /**
     * 企业批增积分，单笔持久化出错不需回滚，必须全部导入
     * @param scoreIncomeDetailDTOs
     * @return
     */
    public BaseResponse batchAddScoreAll(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailDTOs);

    /**
     * 企业查询全部个人账户收入明细
     *
     * @param orgPersonScoreDetailQueryDTO
     * @return
     */
    public PageResponseDTO<ScoreIncomeDetailDTO> queryAllScoreIncomeDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO);

    /**
     * 企业查询全部个人账户支出明细
     *
     * @param orgPersonScoreDetailQueryDTO
     * @return
     */
    public PageResponseDTO<ScoreExpenseDetailDTO> queryAllScoreExpenseDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO);
}
