package score.service.service;

import score.api.dto.entitydto.*;
import score.api.dto.requestdto.*;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import sinomall.config.api.base.BaseResponse;

public interface ScoreService {
    /**
     * 查询积分账户api
     *
     * @param scoreAccountRequestDTO
     * @return
     */
    public ScoreAccountDTO queryScoreAccount(ScoreAccountRequestDTO scoreAccountRequestDTO);

    /**
     * 增加积分api
     *
     * @param scoreIncomeDetailRequestDTO
     * @return
     */
    public TransactionResponseDTO addScore(ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO);

    /**
     * 消费积分api
     *
     * @param scoreExpenseDetailRequestDTO
     * @return
     */
    public TransactionResponseDTO expenseScore(ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO);

    /**
     * 个人查询收入明细api
     *
     * @param scoreDetailQueryDTO
     * @return
     */
    public PageResponseDTO<ScoreIncomeDetailDTO> queryScoreIncomeDetais(ScoreDetailQueryDTO scoreDetailQueryDTO);

    /**
     * 个人查询支出明细api
     *
     * @param scoreDetailQueryDTO
     * @return
     */
    public PageResponseDTO<ScoreExpenseDetailDTO> queryScoreExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO);

    /**
     * 个人支出明细api
     * @param scoreDetailQueryDTO
     * @return
     */
    PageResponseDTO<ScoreIncomeExpenseDetailDTO> queryScoreIncomeExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO);

    ScoreGiveAwayLogDTO scoreGiveAway(ScoreGiveAwayRequestDTO scoreGiveAwayRequestDTO);

    ScoreGiveAwayLogDTO getScoreGiveAwayInfo(GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO);

    ScoreStatisticsResponseDTO scoreExpenseStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO);

    ScoreStatisticsResponseDTO scoreIncomeStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO);

    BaseResponse deleteAccount(String scoreAccountId);
}
