package score.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import score.api.ScoreApi;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.OrgPersonScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.api.exception.BatchAddScoreException;
import score.service.service.OrganizationScoreService;
import score.service.service.ScoreService;
import sinomall.config.api.base.BaseResponse;
import utils.GlobalContants;
import utils.data.BeanMapper;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;

@Service
public class OrganizationScoreServiceImpl implements OrganizationScoreService {
    @Autowired
    ScoreService scoreService;
    @Autowired
    ScoreApi scoreApi;
    Logger logger = LoggerFactory.getLogger(getClass());

    @Transactional
    @Override
    public List<TransactionResponseDTO> batchAddScore(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailRequestDTOS) {
        List<TransactionResponseDTO> transactionResponseDTOS = new ArrayList<>();
        for (ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO : scoreIncomeDetailRequestDTOS) {
            try {
                //每进一笔提交事务
                TransactionResponseDTO transactionResponseDTO = scoreApi.addScore(scoreIncomeDetailRequestDTO);
                transactionResponseDTOS.add(transactionResponseDTO);
            } catch (Exception e) {
                logger.info("持久化导入出错scoreIncomeDetailRequestDTO={}", JSON.toJSONString(scoreIncomeDetailRequestDTO), e);
            }
        }
        return transactionResponseDTOS;
    }

    @Transactional
    @Override
    public BaseResponse batchAddScoreAll(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailRequestDTOS) {
        BaseResponse baseResponse=new BaseResponse(GlobalContants.ResponseStatus.SUCCESS,"调用成功");
        long totaStart = System.currentTimeMillis();
        for (int t = 0; t < scoreIncomeDetailRequestDTOS.size(); t++) {
            try {
                long start = System.currentTimeMillis();
                TransactionResponseDTO transactionResponseDTO = scoreService.addScore(scoreIncomeDetailRequestDTOS.get(t));
                if(!GlobalContants.ResponseStatus.SUCCESS.equals(transactionResponseDTO.getStatus())){
                    throw new RuntimeException(transactionResponseDTO.getResponseMsg());
                }
                logger.info("导入耗时：{}",System.currentTimeMillis()-start);
            } catch (Exception e) {
                logger.info("持久化导入出错scoreIncomeDetailRequestDTO={}", JSON.toJSONString(scoreIncomeDetailRequestDTOS.get(t)), e);
                throw new BatchAddScoreException("导入第" + (t+2) + "行失败", e);
            }
        }
        logger.info("导入数据{},条，耗时:{}",scoreIncomeDetailRequestDTOS.size(),System.currentTimeMillis()-totaStart);
        return baseResponse;
    }

    @Override
    public PageResponseDTO<ScoreIncomeDetailDTO> queryAllScoreIncomeDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO) {
        return scoreService.queryScoreIncomeDetais(BeanMapper.map(orgPersonScoreDetailQueryDTO,ScoreDetailQueryDTO.class));
    }

    @Override
    public PageResponseDTO<ScoreExpenseDetailDTO> queryAllScoreExpenseDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO) {
        return scoreService.queryScoreExpenseDetails(BeanMapper.map(orgPersonScoreDetailQueryDTO,ScoreDetailQueryDTO.class));
    }
}
