package score.service.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.service.service.ScoreLockService;
import score.service.service.ScoreService;
@Service
public class ScoreLockServiceImpl implements ScoreLockService {
    @Autowired
    ScoreService scoreService;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    public TransactionResponseDTO addScore(ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO) {
        return scoreService.addScore(scoreIncomeDetailRequestDTO);
    }
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    public TransactionResponseDTO expenseScore(ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO) {
        return scoreService.expenseScore(scoreExpenseDetailRequestDTO);
    }
}
