package score.service.service.impl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import score.service.service.UniqueSequenceNoService;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 唯一序列号生成api
 */
@MotanService
public class UniqueSequenceNoServiceImpl implements UniqueSequenceNoService {
    @Autowired
    RedisTemplate redisTemplate;

    @Override
    public String generateUniqueSequenceNo() {
        SimpleDateFormat format = new SimpleDateFormat("YYYYMMddHHmmss");
        String dateTime = format.format(new Date());
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(UNIQUE_SEQUENCE_NO_REDIS_KEY);
        Long sequenceNo = boundValueOperations.increment(1);
        if (sequenceNo >= 1000) {
            boundValueOperations.set(0);
        }

        return dateTime + (sequenceNo+1000+"").substring(1);
    }
}
