/*
 * Decompiled with CFR 0.152.
 */
package score.service.apiimpl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import score.api.ScoreApi;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.entitydto.ScoreIncomeExpenseDetailDTO;
import score.api.dto.requestdto.GetScoreGiveAwayInfoRequestDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import score.api.dto.requestdto.ScoreGiveAwayRequestDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.requestdto.ScoreStatisticsRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.api.exception.GiveAwayFailException;
import score.service.service.ScoreLockService;
import score.service.service.ScoreService;
import sinomall.config.api.base.BaseResponse;
import utils.lock.RedisLockUtil;

@MotanService
public class ScoreApiImpl
implements ScoreApi {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ScoreService scoreService;
    @Autowired
    ScoreLockService scoreLockService;
    @Autowired
    RedisLockUtil redisLockUtil;

    public ScoreAccountDTO queryScoreAccount(ScoreAccountRequestDTO scoreAccountRequestDTO) {
        try {
            this.redisLockUtil.lock(":SCORE:CREATE:USER_LOCK:");
            ScoreAccountDTO scoreAccountDTO = this.scoreService.queryScoreAccount(scoreAccountRequestDTO);
            return scoreAccountDTO;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisLockUtil.unlock(":SCORE:CREATE:USER_LOCK:");
        }
    }

    public TransactionResponseDTO addScore(ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO) {
        try {
            this.redisLockUtil.lock(":SCORE:USER_LOCK:" + scoreIncomeDetailRequestDTO.getScoreAccountId());
            TransactionResponseDTO transactionResponseDTO = this.scoreService.addScore(scoreIncomeDetailRequestDTO);
            return transactionResponseDTO;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisLockUtil.unlock(":SCORE:USER_LOCK:" + scoreIncomeDetailRequestDTO.getScoreAccountId());
        }
    }

    public TransactionResponseDTO expenseScore(ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO) {
        try {
            this.redisLockUtil.lock(":SCORE:USER_LOCK:" + scoreExpenseDetailRequestDTO.getScoreAccountId());
            TransactionResponseDTO transactionResponseDTO = this.scoreService.expenseScore(scoreExpenseDetailRequestDTO);
            return transactionResponseDTO;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisLockUtil.unlock(":SCORE:USER_LOCK:" + scoreExpenseDetailRequestDTO.getScoreAccountId());
        }
    }

    public PageResponseDTO<ScoreIncomeDetailDTO> queryScoreIncomeDetais(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        return this.scoreService.queryScoreIncomeDetais(scoreDetailQueryDTO);
    }

    public PageResponseDTO<ScoreExpenseDetailDTO> queryScoreExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        return this.scoreService.queryScoreExpenseDetails(scoreDetailQueryDTO);
    }

    public PageResponseDTO<ScoreIncomeExpenseDetailDTO> queryScoreIncomeExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        return this.scoreService.queryScoreIncomeExpenseDetails(scoreDetailQueryDTO);
    }

    public ScoreGiveAwayLogDTO scoreGiveAway(ScoreGiveAwayRequestDTO scoreGiveAwayRequestDTO) {
        ScoreGiveAwayLogDTO scoreGiveAwayLogDTO;
        block2: {
            scoreGiveAwayLogDTO = new ScoreGiveAwayLogDTO();
            scoreGiveAwayLogDTO.setStatus("error");
            scoreGiveAwayLogDTO.setResponseMsg("\u8d60\u9001\u79ef\u5206\u5931\u8d25");
            try {
                scoreGiveAwayLogDTO = this.scoreService.scoreGiveAway(scoreGiveAwayRequestDTO);
            }
            catch (GiveAwayFailException e) {
                this.logger.error("\u8d60\u9001\u79ef\u5206\u5931\u8d25", (Throwable)e);
                if (StringUtils.isEmpty((Object)e.getMessage())) break block2;
                scoreGiveAwayLogDTO = (ScoreGiveAwayLogDTO)JSON.parseObject((String)e.getMessage(), ScoreGiveAwayLogDTO.class);
            }
        }
        return scoreGiveAwayLogDTO;
    }

    public ScoreGiveAwayLogDTO getScoreGiveAwayInfo(GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO) {
        return this.scoreService.getScoreGiveAwayInfo(getScoreGiveAwayInfoRequestDTO);
    }

    public ScoreStatisticsResponseDTO scoreIncomeStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO) {
        return this.scoreService.scoreIncomeStatics(scoreStatisticsRequestDTO);
    }

    public ScoreStatisticsResponseDTO scoreExpenseStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO) {
        return this.scoreService.scoreExpenseStatics(scoreStatisticsRequestDTO);
    }

    public BaseResponse deleteAccount(String scoreAccountId) {
        return this.scoreService.deleteAccount(scoreAccountId);
    }
}

