/*
 * Decompiled with CFR 0.152.
 */
package score.service.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import score.api.ScoreApi;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.OrgPersonScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.api.exception.BatchAddScoreException;
import score.service.service.OrganizationScoreService;
import score.service.service.ScoreService;
import sinomall.config.api.base.BaseResponse;
import utils.data.BeanMapper;

@Service
public class OrganizationScoreServiceImpl
implements OrganizationScoreService {
    @Autowired
    ScoreService scoreService;
    @Autowired
    ScoreApi scoreApi;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    public List<TransactionResponseDTO> batchAddScore(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailRequestDTOS) {
        ArrayList<TransactionResponseDTO> transactionResponseDTOS = new ArrayList<TransactionResponseDTO>();
        for (ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO : scoreIncomeDetailRequestDTOS) {
            try {
                TransactionResponseDTO transactionResponseDTO = this.scoreApi.addScore(scoreIncomeDetailRequestDTO);
                transactionResponseDTOS.add(transactionResponseDTO);
            }
            catch (Exception e) {
                this.logger.info("\u6301\u4e45\u5316\u5bfc\u5165\u51fa\u9519scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreIncomeDetailRequestDTO), (Object)e);
            }
        }
        return transactionResponseDTOS;
    }

    @Transactional
    public BaseResponse batchAddScoreAll(List<ScoreIncomeDetailRequestDTO> scoreIncomeDetailRequestDTOS) {
        BaseResponse baseResponse = new BaseResponse("success", "\u8c03\u7528\u6210\u529f");
        long totaStart = System.currentTimeMillis();
        for (int t = 0; t < scoreIncomeDetailRequestDTOS.size(); ++t) {
            try {
                long start = System.currentTimeMillis();
                TransactionResponseDTO transactionResponseDTO = this.scoreService.addScore(scoreIncomeDetailRequestDTOS.get(t));
                if (!"success".equals(transactionResponseDTO.getStatus())) {
                    throw new RuntimeException(transactionResponseDTO.getResponseMsg());
                }
                this.logger.info("\u5bfc\u5165\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                continue;
            }
            catch (Exception e) {
                this.logger.info("\u6301\u4e45\u5316\u5bfc\u5165\u51fa\u9519scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreIncomeDetailRequestDTOS.get(t)), (Object)e);
                throw new BatchAddScoreException("\u5bfc\u5165\u7b2c" + (t + 2) + "\u884c\u5931\u8d25", (Throwable)e);
            }
        }
        this.logger.info("\u5bfc\u5165\u6570\u636e{},\u6761\uff0c\u8017\u65f6:{}", (Object)scoreIncomeDetailRequestDTOS.size(), (Object)(System.currentTimeMillis() - totaStart));
        return baseResponse;
    }

    public PageResponseDTO<ScoreIncomeDetailDTO> queryAllScoreIncomeDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO) {
        return this.scoreService.queryScoreIncomeDetais((ScoreDetailQueryDTO)BeanMapper.map((Object)orgPersonScoreDetailQueryDTO, ScoreDetailQueryDTO.class));
    }

    public PageResponseDTO<ScoreExpenseDetailDTO> queryAllScoreExpenseDetails(OrgPersonScoreDetailQueryDTO orgPersonScoreDetailQueryDTO) {
        return this.scoreService.queryScoreExpenseDetails((ScoreDetailQueryDTO)BeanMapper.map((Object)orgPersonScoreDetailQueryDTO, ScoreDetailQueryDTO.class));
    }
}

