/*
 * Decompiled with CFR 0.152.
 */
package score.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.entitydto.ScoreIncomeExpenseDetailDTO;
import score.api.dto.requestdto.GetScoreGiveAwayInfoRequestDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreDetailRequestDTO;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import score.api.dto.requestdto.ScoreGiveAwayRequestDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.requestdto.ScoreStatisticsRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import score.api.exception.GiveAwayFailException;
import score.model.ScoreAccount;
import score.model.ScoreExpenseDetail;
import score.model.ScoreGiveAwayLog;
import score.model.ScoreIncomeDetail;
import score.model.repository.ScoreAccountRepos;
import score.model.repository.ScoreExpenseDetailRepos;
import score.model.repository.ScoreGiveAwayLogRepos;
import score.model.repository.ScoreIncomeDetailRepos;
import score.model.specification.ScoreDetailSpecification;
import score.service.service.ScoreService;
import score.service.service.UniqueSequenceNoService;
import sinomall.config.api.base.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@MotanService
public class ScoreServiceImpl
implements ScoreService {
    @Autowired
    ScoreAccountRepos accountRepos;
    @Autowired
    ScoreIncomeDetailRepos scoreIncomeDetailRepos;
    @Autowired
    ScoreExpenseDetailRepos scoreExpenseDetailRepos;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ScoreApi scoreApi;
    @Autowired
    ScoreGiveAwayLogRepos scoreGiveAwayLogRepos;
    @Autowired
    UniqueSequenceNoService uniqueSequenceNoService;

    @Transactional
    public ScoreAccountDTO queryScoreAccount(ScoreAccountRequestDTO scoreAccountRequestDTO) {
        if (StringUtils.isEmpty((Object)scoreAccountRequestDTO.getOrganizationCode())) {
            throw new RuntimeException("organizationCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScoreAccount scoreAccount = null;
        if (!StringUtils.isEmpty((Object)scoreAccountRequestDTO.getUserId())) {
            scoreAccount = this.accountRepos.findByOrganizationCodeAndUserId(scoreAccountRequestDTO.getOrganizationCode(), scoreAccountRequestDTO.getUserId());
            if (!(scoreAccount == null || StringUtils.isEmpty((Object)scoreAccountRequestDTO.getPhone()) && StringUtils.isEmpty((Object)scoreAccountRequestDTO.getEmail()))) {
                if (!StringUtils.isEmpty((Object)scoreAccountRequestDTO.getPhone()) && !scoreAccountRequestDTO.getPhone().equals(scoreAccount.getPhone())) {
                    scoreAccount.setPhone(scoreAccountRequestDTO.getPhone());
                }
                if (!StringUtils.isEmpty((Object)scoreAccountRequestDTO.getEmail()) && !scoreAccountRequestDTO.getEmail().equals(scoreAccount.getEmail())) {
                    scoreAccount.setEmail(scoreAccountRequestDTO.getEmail());
                }
                if (!StringUtils.isEmpty((Object)scoreAccountRequestDTO.getNickName()) && !scoreAccountRequestDTO.getNickName().equals(scoreAccount.getNickName())) {
                    scoreAccount.setNickName(scoreAccountRequestDTO.getNickName());
                }
                this.accountRepos.saveAndFlush((Object)scoreAccount);
            }
        } else if (!StringUtils.isEmpty((Object)scoreAccountRequestDTO.getPhone())) {
            scoreAccount = this.accountRepos.findByOrganizationCodeAndPhone(scoreAccountRequestDTO.getOrganizationCode(), scoreAccountRequestDTO.getPhone());
        } else if (!StringUtils.isEmpty((Object)scoreAccountRequestDTO.getEmail())) {
            scoreAccount = this.accountRepos.findByOrganizationCodeAndEmail(scoreAccountRequestDTO.getOrganizationCode(), scoreAccountRequestDTO.getEmail());
        }
        if (scoreAccount == null) {
            scoreAccount = (ScoreAccount)BeanMapper.map((Object)scoreAccountRequestDTO, ScoreAccount.class);
            scoreAccount.setIncomeScoreVal(new BigDecimal(0));
            scoreAccount.setExpendedScoreVal(new BigDecimal(0));
            scoreAccount.setFreezeScoreVal(new BigDecimal(0));
            scoreAccount.setInvalidScoreVal(new BigDecimal(0));
            scoreAccount.setAboutOfInvalidScoreVal(new BigDecimal(0));
            scoreAccount.setLastUpdated(new Date());
            this.accountRepos.saveAndFlush((Object)scoreAccount);
        }
        return (ScoreAccountDTO)BeanMapper.map((Object)scoreAccount, ScoreAccountDTO.class);
    }

    @Transactional
    public TransactionResponseDTO addScore(ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO) {
        TransactionResponseDTO transactionResponseDTO = new TransactionResponseDTO();
        transactionResponseDTO.setStatus("success");
        if (!this.validateRequestParam((ScoreDetailRequestDTO)scoreIncomeDetailRequestDTO, transactionResponseDTO)) {
            transactionResponseDTO.setStatus("error");
            return transactionResponseDTO;
        }
        ScoreAccount scoreAccount = (ScoreAccount)this.accountRepos.findOne((Serializable)((Object)scoreIncomeDetailRequestDTO.getScoreAccountId()));
        if (scoreAccount == null) {
            String returnMsg = "\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u8d26\u6237";
            transactionResponseDTO.setResponseMsg(returnMsg);
            transactionResponseDTO.setStatus("error");
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreIncomeDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return transactionResponseDTO;
        }
        Integer countTransactionNo = this.scoreIncomeDetailRepos.validateIncomeTransactionNo(scoreAccount.getOrganizationCode(), scoreIncomeDetailRequestDTO.getTransactionNo());
        if (countTransactionNo > 0) {
            String returnMsg = "\u4ea4\u6613\u6d41\u6c34\u53f7\u91cd\u590d";
            transactionResponseDTO.setResponseMsg(returnMsg);
            transactionResponseDTO.setStatus("error");
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreIncomeDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return transactionResponseDTO;
        }
        ScoreIncomeDetail incomeDetail = (ScoreIncomeDetail)BeanMapper.map((Object)scoreIncomeDetailRequestDTO, ScoreIncomeDetail.class);
        incomeDetail.setScoreAccount(scoreAccount);
        incomeDetail.setScoreRcptCode(this.uniqueSequenceNoService.generateUniqueSequenceNo());
        this.scoreIncomeDetailRepos.saveAndFlush((Object)incomeDetail);
        scoreAccount.setIncomeScoreVal(scoreAccount.getIncomeScoreVal().add(incomeDetail.getScoreVal()));
        this.accountRepos.saveAndFlush((Object)scoreAccount);
        transactionResponseDTO.setStatus("success");
        transactionResponseDTO.setResponseMsg("\u8c03\u7528\u6210\u529f");
        transactionResponseDTO.setScoreRcptCode(incomeDetail.getScoreRcptCode());
        return transactionResponseDTO;
    }

    public boolean validateRequestParam(ScoreDetailRequestDTO scoreDetailRequestDTO, TransactionResponseDTO transactionResponseDTO) {
        String returnMsg = "";
        if (StringUtils.isEmpty((Object)scoreDetailRequestDTO.getScoreAccountId())) {
            returnMsg = "\u79ef\u5206\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a";
            transactionResponseDTO.setResponseMsg(returnMsg);
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return false;
        }
        if (StringUtils.isEmpty((Object)scoreDetailRequestDTO.getTransactionNo())) {
            returnMsg = "\u8bf7\u6c42\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
            transactionResponseDTO.setResponseMsg(returnMsg);
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return false;
        }
        if (scoreDetailRequestDTO.getScoreVal() == null || scoreDetailRequestDTO.getScoreVal().compareTo(new BigDecimal(0)) < 0) {
            returnMsg = "\u4f20\u5165\u79ef\u5206\u503c\u4e0d\u6b63\u786e";
            transactionResponseDTO.setResponseMsg(returnMsg);
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return false;
        }
        return true;
    }

    @Transactional
    public TransactionResponseDTO expenseScore(ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO) {
        TransactionResponseDTO transactionResponseDTO = new TransactionResponseDTO();
        transactionResponseDTO.setStatus("success");
        if (!this.validateRequestParam((ScoreDetailRequestDTO)scoreExpenseDetailRequestDTO, transactionResponseDTO)) {
            transactionResponseDTO.setStatus("error");
            return transactionResponseDTO;
        }
        ScoreAccount scoreAccount = (ScoreAccount)this.accountRepos.findOne((Serializable)((Object)scoreExpenseDetailRequestDTO.getScoreAccountId()));
        if (scoreAccount == null) {
            String returnMsg = "\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u8d26\u6237";
            transactionResponseDTO.setResponseMsg(returnMsg);
            transactionResponseDTO.setStatus("error");
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreExpenseDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return transactionResponseDTO;
        }
        Integer countTransactionNo = this.scoreExpenseDetailRepos.validateExpenseTransactionNo(scoreAccount.getOrganizationCode(), scoreExpenseDetailRequestDTO.getTransactionNo());
        if (countTransactionNo > 0) {
            String returnMsg = "\u4ea4\u6613\u6d41\u6c34\u53f7\u91cd\u590d";
            transactionResponseDTO.setResponseMsg(returnMsg);
            transactionResponseDTO.setStatus("error");
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreExpenseDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return transactionResponseDTO;
        }
        if (scoreAccount.getIncomeScoreVal().setScale(2, 5).compareTo(scoreAccount.getExpendedScoreVal().add(scoreExpenseDetailRequestDTO.getScoreVal()).setScale(2, 5)) < 0) {
            String returnMsg = "\u8d26\u6237\u79ef\u5206\u4e0d\u8db3";
            transactionResponseDTO.setResponseMsg(returnMsg);
            transactionResponseDTO.setStatus("error");
            this.logger.error(returnMsg + ",scoreIncomeDetailRequestDTO={}", (Object)JSON.toJSONString((Object)scoreExpenseDetailRequestDTO), (Object)new RuntimeException(returnMsg));
            return transactionResponseDTO;
        }
        ScoreExpenseDetail expenseDetail = (ScoreExpenseDetail)BeanMapper.map((Object)scoreExpenseDetailRequestDTO, ScoreExpenseDetail.class);
        expenseDetail.setScoreAccount(scoreAccount);
        expenseDetail.setScoreRcptCode(this.uniqueSequenceNoService.generateUniqueSequenceNo());
        this.scoreExpenseDetailRepos.saveAndFlush((Object)expenseDetail);
        scoreAccount.setExpendedScoreVal(scoreAccount.getExpendedScoreVal().add(expenseDetail.getScoreVal()));
        this.accountRepos.saveAndFlush((Object)scoreAccount);
        transactionResponseDTO.setStatus("success");
        transactionResponseDTO.setResponseMsg("\u8c03\u7528\u6210\u529f");
        transactionResponseDTO.setScoreRcptCode(expenseDetail.getScoreRcptCode());
        return transactionResponseDTO;
    }

    public PageResponseDTO<ScoreIncomeDetailDTO> queryScoreIncomeDetais(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        ScoreDetailSpecification scoreDetailSpecification = new ScoreDetailSpecification(scoreDetailQueryDTO);
        if (scoreDetailQueryDTO.getPage() == null) {
            List scoreIncomeDetailsAll = this.scoreIncomeDetailRepos.findAll((Specification)scoreDetailSpecification, new Sort(Sort.Direction.DESC, new String[]{"transaTime"}));
            return new PageResponseDTO(Integer.valueOf(1), Long.valueOf(scoreIncomeDetailsAll.size()), BeanMapper.mapList((Iterable)scoreIncomeDetailsAll, ScoreIncomeDetail.class, ScoreIncomeDetailDTO.class));
        }
        Page scoreIncomeDetails = this.scoreIncomeDetailRepos.findAll((Specification)scoreDetailSpecification, (Pageable)new PageRequest(scoreDetailQueryDTO.getPage().intValue(), scoreDetailQueryDTO.getPageSize().intValue(), new Sort(Sort.Direction.DESC, new String[]{"transaTime"})));
        return new PageResponseDTO(Integer.valueOf(scoreIncomeDetails.getTotalPages()), Long.valueOf(scoreIncomeDetails.getTotalElements()), BeanMapper.mapList((Iterable)scoreIncomeDetails.getContent(), ScoreIncomeDetail.class, ScoreIncomeDetailDTO.class));
    }

    public PageResponseDTO<ScoreExpenseDetailDTO> queryScoreExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        ScoreDetailSpecification scoreDetailSpecification = new ScoreDetailSpecification(scoreDetailQueryDTO);
        if (scoreDetailQueryDTO.getPage() == null) {
            List scoreExpenseDetailAll = this.scoreExpenseDetailRepos.findAll((Specification)scoreDetailSpecification, new Sort(Sort.Direction.DESC, new String[]{"transaTime"}));
            return new PageResponseDTO(Integer.valueOf(1), Long.valueOf(scoreExpenseDetailAll.size()), BeanMapper.mapList((Iterable)scoreExpenseDetailAll, ScoreExpenseDetail.class, ScoreExpenseDetailDTO.class));
        }
        Page scoreExpenseDetails = this.scoreExpenseDetailRepos.findAll((Specification)scoreDetailSpecification, (Pageable)new PageRequest(scoreDetailQueryDTO.getPage().intValue(), scoreDetailQueryDTO.getPageSize().intValue(), new Sort(Sort.Direction.DESC, new String[]{"transaTime"})));
        return new PageResponseDTO(Integer.valueOf(scoreExpenseDetails.getTotalPages()), Long.valueOf(scoreExpenseDetails.getTotalElements()), BeanMapper.mapList((Iterable)scoreExpenseDetails.getContent(), ScoreExpenseDetail.class, ScoreExpenseDetailDTO.class));
    }

    public PageResponseDTO<ScoreIncomeExpenseDetailDTO> queryScoreIncomeExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        ArrayList<ScoreIncomeExpenseDetailDTO> scoreIncomeExpenseDetailList = new ArrayList<ScoreIncomeExpenseDetailDTO>();
        Integer totalPage = 1;
        BigDecimal rowCount = new BigDecimal(0);
        if (!Lang.isEmpty((Object)scoreDetailQueryDTO) && !Lang.isEmpty((Object)scoreDetailQueryDTO.getScoreAccountIds())) {
            String scoreAccountId = (String)scoreDetailQueryDTO.getScoreAccountIds().get(0);
            rowCount = this.scoreExpenseDetailRepos.getIncomeExpenseDetailCount(scoreAccountId);
            int start = scoreDetailQueryDTO.getPage() * scoreDetailQueryDTO.getPageSize() + 1;
            int end = start + scoreDetailQueryDTO.getPageSize();
            totalPage = rowCount.intValue() % scoreDetailQueryDTO.getPageSize() == 0 ? rowCount.intValue() / scoreDetailQueryDTO.getPageSize() : rowCount.intValue() / scoreDetailQueryDTO.getPageSize() + 1;
            List rows = this.scoreExpenseDetailRepos.queryIncomeExpenseDetail(scoreAccountId, Integer.valueOf(start), Integer.valueOf(end));
            for (Object[] obj : rows) {
                Date transaTime = (Date)obj[2];
                String busiSource = (String)obj[3];
                BigDecimal scoreVal = (BigDecimal)obj[4];
                String memo = (String)obj[5];
                ScoreIncomeExpenseDetailDTO scoreIncomeExpenseDetail = new ScoreIncomeExpenseDetailDTO();
                scoreIncomeExpenseDetail.setTransaTime(transaTime);
                scoreIncomeExpenseDetail.setBusiSource(busiSource);
                scoreIncomeExpenseDetail.setScoreVal(scoreVal);
                scoreIncomeExpenseDetail.setMemo(memo);
                scoreIncomeExpenseDetailList.add(scoreIncomeExpenseDetail);
            }
        }
        return new PageResponseDTO(totalPage, Long.valueOf(rowCount.longValue()), scoreIncomeExpenseDetailList);
    }

    @Transactional
    public ScoreGiveAwayLogDTO scoreGiveAway(ScoreGiveAwayRequestDTO scoreGiveAwayRequestDTO) {
        ScoreGiveAwayLogDTO scoreGiveAwayLogDTO = new ScoreGiveAwayLogDTO();
        ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO = new ScoreExpenseDetailRequestDTO();
        scoreExpenseDetailRequestDTO.setScoreAccountId(scoreGiveAwayRequestDTO.getGiveAwayScoreAccountId());
        scoreExpenseDetailRequestDTO.setMemo(scoreGiveAwayRequestDTO.getMemo());
        scoreExpenseDetailRequestDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        scoreExpenseDetailRequestDTO.setBusiSource(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessSource());
        scoreExpenseDetailRequestDTO.setTransactionNo(this.uniqueSequenceNoService.generateUniqueSequenceNo());
        scoreExpenseDetailRequestDTO.setScoreVal(scoreGiveAwayRequestDTO.getScoreVal());
        scoreExpenseDetailRequestDTO.setTransaTime(scoreGiveAwayRequestDTO.getGiveAwayTime());
        TransactionResponseDTO expenseTransactionResponseDTO = this.scoreApi.expenseScore(scoreExpenseDetailRequestDTO);
        if (!"success".equals(expenseTransactionResponseDTO.getStatus())) {
            scoreGiveAwayLogDTO.setStatus(expenseTransactionResponseDTO.getStatus());
            scoreGiveAwayLogDTO.setResponseMsg(expenseTransactionResponseDTO.getResponseMsg());
            throw new GiveAwayFailException(JSON.toJSONString((Object)scoreGiveAwayLogDTO));
        }
        ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO = new ScoreIncomeDetailRequestDTO();
        scoreIncomeDetailRequestDTO.setScoreAccountId(scoreGiveAwayRequestDTO.getReceiveScoreAccountId());
        scoreIncomeDetailRequestDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_RECEIVE.getBusinessCode());
        scoreIncomeDetailRequestDTO.setBusiSource(ScoreBusinessType.BUSI_INCOME_RECEIVE.getBusinessSource());
        scoreIncomeDetailRequestDTO.setMemo(scoreGiveAwayRequestDTO.getMemo());
        scoreIncomeDetailRequestDTO.setScoreVal(scoreGiveAwayRequestDTO.getScoreVal());
        scoreIncomeDetailRequestDTO.setTransactionNo(this.uniqueSequenceNoService.generateUniqueSequenceNo());
        scoreIncomeDetailRequestDTO.setTransaTime(scoreGiveAwayRequestDTO.getGiveAwayTime());
        TransactionResponseDTO incomeTransactionResponseDTO = this.scoreApi.addScore(scoreIncomeDetailRequestDTO);
        if (!"success".equals(incomeTransactionResponseDTO.getStatus())) {
            scoreGiveAwayLogDTO.setStatus(incomeTransactionResponseDTO.getStatus());
            scoreGiveAwayLogDTO.setResponseMsg(incomeTransactionResponseDTO.getResponseMsg());
            throw new GiveAwayFailException(JSON.toJSONString((Object)scoreGiveAwayLogDTO));
        }
        ScoreGiveAwayLog scoreGiveAwayLog = (ScoreGiveAwayLog)BeanMapper.map((Object)scoreGiveAwayRequestDTO, ScoreGiveAwayLog.class);
        scoreGiveAwayLog.setGiveAwayScoreAccount((ScoreAccount)this.accountRepos.findOne((Serializable)((Object)scoreGiveAwayRequestDTO.getGiveAwayScoreAccountId())));
        scoreGiveAwayLog.setReceiveScoreAccount((ScoreAccount)this.accountRepos.findOne((Serializable)((Object)scoreGiveAwayRequestDTO.getReceiveScoreAccountId())));
        scoreGiveAwayLog.setScoreExpenseRcptCode(expenseTransactionResponseDTO.getScoreRcptCode());
        scoreGiveAwayLog.setScoreIncomeRcptCode(incomeTransactionResponseDTO.getScoreRcptCode());
        this.scoreGiveAwayLogRepos.saveAndFlush((Object)scoreGiveAwayLog);
        scoreGiveAwayLogDTO = (ScoreGiveAwayLogDTO)BeanMapper.map((Object)scoreGiveAwayLog, ScoreGiveAwayLogDTO.class);
        scoreGiveAwayLogDTO.setStatus("success");
        scoreGiveAwayLogDTO.setResponseMsg("\u8c03\u7528\u6210\u529f");
        return scoreGiveAwayLogDTO;
    }

    public ScoreGiveAwayLogDTO getScoreGiveAwayInfo(GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO) {
        String scoreIncomeRcptCode = getScoreGiveAwayInfoRequestDTO.getScoreIncomeRcptCode();
        String scoreExpenseRcptCode = getScoreGiveAwayInfoRequestDTO.getScoreExpenseRcptCode();
        ScoreGiveAwayLog scoreGiveAwaylog = Lang.isEmpty((Object)scoreIncomeRcptCode) ? this.scoreGiveAwayLogRepos.getScoreGiveAwayByExpenseCode(scoreExpenseRcptCode) : (Lang.isEmpty((Object)scoreExpenseRcptCode) ? this.scoreGiveAwayLogRepos.getScoreGiveAwayByIncomeCode(scoreIncomeRcptCode) : this.scoreGiveAwayLogRepos.getScoreGiveAwayInfo(scoreIncomeRcptCode, scoreExpenseRcptCode));
        if (scoreGiveAwaylog == null) {
            return null;
        }
        return (ScoreGiveAwayLogDTO)BeanMapper.map((Object)scoreGiveAwaylog, ScoreGiveAwayLogDTO.class);
    }

    public ScoreStatisticsResponseDTO scoreExpenseStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO) {
        if (StringUtils.isEmpty((Object)scoreStatisticsRequestDTO.getScoreAccountId())) {
            BigDecimal scoreVal = this.scoreExpenseDetailRepos.queryOrgExpenseStaticsVal(scoreStatisticsRequestDTO.getOrganizationCode(), scoreStatisticsRequestDTO.getBusiCode());
            return new ScoreStatisticsResponseDTO(scoreVal);
        }
        BigDecimal scoreVal = this.scoreExpenseDetailRepos.queryExpenseStaticsVal(scoreStatisticsRequestDTO.getOrganizationCode(), scoreStatisticsRequestDTO.getScoreAccountId(), scoreStatisticsRequestDTO.getBusiCode());
        if (scoreVal == null) {
            scoreVal = new BigDecimal("0");
        }
        return new ScoreStatisticsResponseDTO(scoreVal);
    }

    public ScoreStatisticsResponseDTO scoreIncomeStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO) {
        if (StringUtils.isEmpty((Object)scoreStatisticsRequestDTO.getScoreAccountId())) {
            BigDecimal scoreVal = this.scoreIncomeDetailRepos.queryOrgIncomeStaticsVal(scoreStatisticsRequestDTO.getOrganizationCode(), scoreStatisticsRequestDTO.getBusiCode());
            return new ScoreStatisticsResponseDTO(scoreVal);
        }
        BigDecimal scoreVal = this.scoreIncomeDetailRepos.queryIncomeStaticsVal(scoreStatisticsRequestDTO.getOrganizationCode(), scoreStatisticsRequestDTO.getScoreAccountId(), scoreStatisticsRequestDTO.getBusiCode());
        if (scoreVal == null) {
            scoreVal = new BigDecimal("0");
        }
        return new ScoreStatisticsResponseDTO(scoreVal);
    }

    public BaseResponse deleteAccount(String scoreAccountId) {
        BaseResponse baseResponse = new BaseResponse("error", "\u5931\u8d25");
        if (StringUtils.isEmpty((Object)scoreAccountId)) {
            baseResponse.setResponseMsg("\u8d26\u6237id\u4e0d\u592a\u80fd\u4e3a\u7a7a");
            return baseResponse;
        }
        ScoreAccount scoreAccount = (ScoreAccount)this.accountRepos.findOne((Serializable)((Object)scoreAccountId));
        if (scoreAccount == null) {
            baseResponse.setResponseMsg("\u65e0\u5bf9\u5e94\u8d26\u6237");
            return baseResponse;
        }
        scoreAccount.setIsDelete(Boolean.valueOf(true));
        scoreAccount.setUserId(scoreAccountId + "__delete");
        this.accountRepos.saveAndFlush((Object)scoreAccount);
        baseResponse.setStatus("success");
        baseResponse.setResponseMsg("\u6ce8\u9500\u6210\u529f");
        return baseResponse;
    }
}

