/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.admin.login.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.admin.login.service.AdminRoleService;
import sinosoftgz.admin.login.service.AdminUserService;
import sinosoftgz.admin.login.vo.JqueryDataTablesVo;
import sinosoftgz.admin.login.vo.query.UserQueryVo;
import sinosoftgz.admin.login.vo.query.UserVo;
import sinosoftgz.admin.sso.AdminRole;
import sinosoftgz.admin.sso.AdminUser;
import sinosoftgz.utils.Lang;

@Controller
@RequestMapping(value={"/admin/user"})
public class UserController {
    @Autowired
    AdminUserService adminUserService;
    @Autowired
    AdminRoleService adminRoleService;

    @RequestMapping(value={"", "/list"})
    public String showPrepareNameInput() {
        return "user/userList";
    }

    @RequestMapping(value={"userList"})
    @ResponseBody
    public Map userList(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, UserQueryVo userQueryVo) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page userPage = null;
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        userPage = Lang.isEmpty((Object)userQueryVo.getUsername()) && Lang.isEmpty((Object)userQueryVo.getValidFlag()) ? this.adminUserService.getUserByPage(pageable) : this.adminUserService.getUserByParamsAndPage(userQueryVo.getUsername(), userQueryVo.getValidFlag(), pageable);
        List userList = userPage.getContent();
        ArrayList<UserVo> UserVoList = new ArrayList<UserVo>();
        for (int i = 0; i < userList.size(); ++i) {
            UserVo userVo = new UserVo();
            userVo.setId(((AdminUser)userList.get(i)).getId());
            userVo.setUsername(((AdminUser)userList.get(i)).getUsername());
            if (!Lang.isEmpty((Object)((AdminUser)userList.get(i)).getRoles())) {
                userVo.setRolename(((AdminRole)((AdminUser)userList.get(i)).getRoles().get(0)).getName());
            }
            userVo.setPhone(((AdminUser)userList.get(i)).getPhone());
            userVo.setValidFlag(((AdminUser)userList.get(i)).getValidFlag().booleanValue());
            UserVoList.add(userVo);
        }
        returnModel.putAll(jqueryDataTablesVo.toMap());
        returnModel.put("aaData", UserVoList);
        returnModel.put("iTotalRecords", Long.valueOf(userPage.getTotalElements()));
        returnModel.put("iTotalDisplayRecords", Long.valueOf(userPage.getTotalElements()));
        return returnModel;
    }

    @RequestMapping(value={"add"})
    public String userAdd(Map returnModel) {
        List adminRoleList = null;
        adminRoleList = this.adminRoleService.getRoleList();
        returnModel.put("adminRoleList", adminRoleList);
        return "user/editUser";
    }

    @RequestMapping(value={"edit"})
    public String userEdit(String id, Map model) {
        List adminRoleList = null;
        if (StringUtils.isNotBlank((String)id)) {
            AdminUser adminUser = this.adminUserService.findUserById(id);
            adminRoleList = this.adminRoleService.getRoleList();
            model.put("adminRoleList", adminRoleList);
            model.put("adminUser", adminUser);
        }
        return "user/editUser";
    }

    @PostMapping(value={"saveUser"})
    @ResponseBody
    public Map saveUser(AdminUser adminUser, String roleId) {
        Map map;
        AdminRole adminRole;
        String responseMessage = "";
        String resultStatus = "success";
        responseMessage = Lang.isEmpty((Object)adminUser.getId()) ? "\u6570\u636e\u6dfb\u52a0\u6210\u529f!" : "\u6570\u636e\u4fee\u6539\u6210\u529f!";
        if (!Lang.isEmpty((Object)roleId) && !Lang.isEmpty((Object)(adminRole = this.adminRoleService.findRoleById(roleId)).getName())) {
            ((AdminRole)adminUser.getRoles().get(0)).setName(adminRole.getName());
        }
        if ((map = this.adminUserService.saveUser(adminUser)).get("status").equals("error")) {
            resultStatus = "error";
            responseMessage = "\u6570\u636e\u4fdd\u5b58\u5931\u8d25!";
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("status", resultStatus);
        model.put("message", responseMessage);
        return model;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Map deleteUser(String id) {
        Map<String, String> model = new HashMap<String, String>();
        if (!Lang.isEmpty((Object)id)) {
            model = this.adminUserService.deleteById(id);
        } else {
            model.put("status", "error");
            model.put("message", "\u7528\u6237\u5220\u9664\u64cd\u4f5c\u5931\u8d25!");
        }
        return model;
    }
}

