CREATE TABLE admin_login_history
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  app_platfrom VARCHAR(255),
  browser VARCHAR(255),
  code VARCHAR(255),
  device VARCHAR(255),
  login_time DATETIME,
  login_type VARCHAR(255),
  login_url VARCHAR(255),
  logout_time DATETIME,
  message VARCHAR(255),
  platform VARCHAR(255),
  provider VARCHAR(255),
  session_id VARCHAR(255),
  source_ip VARCHAR(255),
  user_id VARCHAR(255)
);
CREATE TABLE admin_menu
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  code VARCHAR(255),
  icon VARCHAR(255),
  icon_large VARCHAR(255),
  name VARCHAR(255),
  target VARCHAR(255),
  url VARCHAR(255),
  perm_id VARCHAR(36),
  parent_id VARCHAR(36),
  CONSTRAINT fk_menu_prem FOREIGN KEY (perm_id) REFERENCES admin_perms (id),
  CONSTRAINT fk_admin_menu_parent FOREIGN KEY (parent_id) REFERENCES admin_menu (id)
);
CREATE INDEX fk_admin_menu_parent ON admin_menu (parent_id);
CREATE INDEX fk_menu_prem ON admin_menu (perm_id);
CREATE TABLE admin_perms
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  code VARCHAR(255),
  name VARCHAR(255),
  url VARCHAR(255)
);
CREATE TABLE admin_resource
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  perm_exp VARCHAR(255),
  url VARCHAR(50)
);
CREATE TABLE admin_role
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  code VARCHAR(255),
  name VARCHAR(255),
  valid_flag BIT(1)
);
CREATE TABLE admin_role_links
(
  admin_id VARCHAR(36) NOT NULL,
  role_id VARCHAR(36) NOT NULL,
  CONSTRAINT fk_mr_links_role_admin FOREIGN KEY (admin_id) REFERENCES admin_user (id),
  CONSTRAINT fk_mr_links_admin_role FOREIGN KEY (role_id) REFERENCES admin_role (id)
);
CREATE INDEX fk_mr_links_admin_role ON admin_role_links (role_id);
CREATE INDEX fk_mr_links_role_admin ON admin_role_links (admin_id);
CREATE TABLE admin_role_menus_links
(
  role_id VARCHAR(36) NOT NULL,
  menu_id VARCHAR(36) NOT NULL,
  CONSTRAINT admin_rp_links_menus_role FOREIGN KEY (role_id) REFERENCES admin_system (id),
  CONSTRAINT fk_admin_links_role_menus FOREIGN KEY (menu_id) REFERENCES admin_role (id)
);
CREATE INDEX admin_rp_links_menus_role ON admin_role_menus_links (role_id);
CREATE INDEX fk_admin_links_role_menus ON admin_role_menus_links (menu_id);
CREATE TABLE admin_role_prems_links
(
  role_id VARCHAR(36) NOT NULL,
  perm_id VARCHAR(36) NOT NULL,
  CONSTRAINT fk_admin_links_role_prems FOREIGN KEY (role_id) REFERENCES admin_perms (id),
  CONSTRAINT admin_rp_links_prems_role FOREIGN KEY (perm_id) REFERENCES admin_role (id)
);
CREATE INDEX admin_rp_links_prems_role ON admin_role_prems_links (perm_id);
CREATE INDEX fk_admin_links_role_prems ON admin_role_prems_links (role_id);
CREATE TABLE admin_system
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  code VARCHAR(255),
  icon VARCHAR(255),
  icon_large VARCHAR(255),
  name VARCHAR(255),
  target VARCHAR(255),
  url VARCHAR(255),
  perm_id VARCHAR(36)
);
CREATE TABLE admin_user
(
  id VARCHAR(36) PRIMARY KEY NOT NULL,
  date_created DATETIME,
  delete_date DATETIME,
  is_delete BIT(1),
  last_updated DATETIME,
  version INT(11),
  email VARCHAR(30),
  last_login_ip VARCHAR(255),
  last_login_time DATETIME,
  login_error_count INT(11),
  login_error_desc VARCHAR(255),
  password VARCHAR(128) NOT NULL,
  phone VARCHAR(20),
  salt VARCHAR(16),
  state VARCHAR(10),
  username VARCHAR(50) NOT NULL,
  valid_flag BIT(1)
);
CREATE UNIQUE INDEX idx_admin_user ON admin_user (username);