<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>商城统一管理后台</title>
<#include "../include/head.ftl" />
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper" id="main-containter">
<#include "../include/top-menu.ftl"/>
    <!-- Left side column. contains the logo and sidebar -->
<#include "../include/left.ftl"/>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                角色管理
            </h1>
            <ol class="breadcrumb">
                <li><a href="${ctx}"><i class="fa fa-dashboard"></i> 首页</a></li>
                <li ><a href="${ctx}/role/list">角色管理</a></li>
                <li class="active"><a href="#">编辑角色</a></li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">编辑角色</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" action="${ctx}/role/update" method="post">
                            <input id="perms_sel" type="hidden" value="${sb!}">
                            <input id="role_id" type="hidden" name="id" value="${role.id!}"/>
                            <div class="box-body">
                                <div class="form-group">
                                    <label for="inputEmail3" class="col-sm-2 control-label">角色名</label>

                                    <div class="col-sm-5">
                                        <input id="role_name" type="text" class="form-control"  name="name" value="${role.name!}"  required placeholder="角色名">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="inputPassword3" class="col-sm-2 control-label">有效状态</label>

                                    <div class="col-sm-2">
                                        <select class="form-control" id="role_validFlag" name="validFlag">
                                            <#if "${role.validFlag?c}" == "false">
                                                <option value="true">有效</option>
                                                <option value="false" selected="selected">无效</option>
                                            <#else>
                                                <option value="true">有效</option>
                                                <option value="false">无效</option>
                                            </#if>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="inputPassword3" class="col-sm-2 control-label">角色权限</label>

                                    <div style="margin-top: 12px;" class="col-sm-10" id="role_perms">
                                        <#--<ul>-->
                                            <#--<li>全部-->
                                            <#--<#list lists>-->
                                                <#--<ul id="perms_list">-->
                                                    <#--<#items as list>-->
                                                        <#--<li id="${list.id!}">${list.name!}</li>-->
                                                    <#--</#items>-->
                                                <#--</ul>-->
                                            <#--</#list>-->
                                            <#--</li>-->
                                        <#--</ul>-->
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <button type="button" class="btn btn-default" onclick="cancel('${ctx}/role/list')">取消</button>
                                <button id="sub" type="button" class="btn btn-info pull-right">保存</button>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>



<#include "../include/foot.ftl"/>
</div>
<!-- ./wrapper -->
<#include "../include/resource.ftl"/>

<script type="text/javascript">
    function cancel(url){
        window.location.href=url;
    }

    //jsTree
    var r = [];

    $(function(){
        $('#role_perms').jstree({
            "plugins" : ["checkbox" ],
            "core":{
                "data":{
                    "type":"post",
                    "url":"${ctx}/role/jstree",
                    "data":function (data) {
                        return data;
                    }
                }
            }
        });
        $('#role_perms').on("ready.jstree", function(e, data){
            data.instance.open_all();
        });
        $('#role_perms').on("changed.jstree", function (e, data) {
            console.log(data.selected);
        });
        $("#role_perms").bind("ready.jstree", function () {//jstree绑定事件，进入页面默认勾选用户权限
            if ($("#perms_sel").val() != ""){
                var sel = [];
                sel = $("#perms_sel").val().split("@@");
                for (var i=0;i<sel.length;i++) {
                    $('#role_perms').jstree('select_node',sel[i]);
                }
            }
        });
    });

    $('#role_perms').on('changed.jstree', function(e, data) {
        r = [];
        var i, j;
        for (i = 0, j = data.selected.length; i < j; i++) {
            var node = data.instance.get_node(data.selected[i]);
            if (data.instance.is_leaf(node)) {
                r.push(node.id);
            }
        }
//        alert('Selected: ' + r.join('@@'));
    })

    $(function () {
        $("#sub").click(function () {
            var roleName = trim($("#role_name").val());
            if(roleName==null || roleName==""){
                window.wxc.xcConfirm("很抱歉，角色名不能为空", "newCustom");
            }
            else if(sameRoleName()==false){
                window.wxc.xcConfirm("很抱歉，角色名已存在，换个角色名试试", "newCustom");
            }
            else if(r.toString() == "" || r.toString() == null){
                window.wxc.xcConfirm("请选择角色权限", "newCustom");
            }
            else {
            $.ajax({
                data:{"selectedNodes":r.join('@@'),
                    "role_id":$("#role_id").val(),
                    "role_name":$("#role_name").val(),
                    "role_validFlag":$("#role_validFlag").val()},
                type:"POST",
                url:"${ctx}/role/update",
                success:function (data) {
                    if (data.status=="success"){
                        var option = {
                            onOk: function () {
                                window.location.href="${ctx}/role/list";
                            }
                        }
                        window.wxc.xcConfirm("保存成功", "success", option);
                        setTimeout(function () {
                            window.location.href="${ctx}/role/list";
                        }, 3000);
                        <#--window.wxc.xcConfirm("保存成功", "custom");-->
                        <#--window.location.href = "${ctx}/role/list";-->
                    }else if(data.status=="error"){
                        window.wxc.xcConfirm(data.message, "newCustom", option);
                    }
                },
                error: function () {
                    window.wxc.xcConfirm("异常，请联系管理员。", "error");
                    console.log("error");
                }
            });
            }
        });
    });

    function sameRoleName() {
        var result;
        var roleName = trim($("#role_name").val());
        {
        $.ajax({
            data:{
                "id":$("#role_id").val(),
                "roleName":roleName},
            type:"POST",
            async: false,
            url:"${ctx}/role/sameRoleName",
            success:function (data) {
                if (data=="1"){
                    result = false;
                }else if(data=="0"){
                    result = true;
                }
            },
            error: function () {
                alert("异常！");
                console.log("error");
            }
        });}
        return result;
    }

    function trim(str){ //删除左右两端的空格
        return str.replace(/(^\s*)|(\s*$)/g, "");
    }

//    $(function () {
//        var nodes = $('#role_perms').jstree().get_checked();
//        alert(nodes);
//        $('#role_perms').jstree(true).select_node('e1acba8a-aac5-4594-8c9f-9445fbea163a');
//        $('#role_perms').jstree('select_node','00faad13-3882-47bd-9280-c6e47ecb1424');
//        $.jstree.reference('#role_perms').select_node('00faad13-3882-47bd-9280-c6e47ecb1424');
//    });

</script>
</body>
</html>
