<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>商城统一管理后台</title>
<#include "../include/head.ftl" />
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper" id="main-containter">
<#include "../include/top-menu.ftl"/>
    <!-- Left side column. contains the logo and sidebar -->
<#include "../include/left.ftl"/>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                角色管理
            </h1>
            <ol class="breadcrumb">
                <li><a href="${ctx}"><i class="fa fa-dashboard"></i> 首页</a></li>
                <li class="active"><a href="#">角色管理</a></li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <form class="form-inline well">
                        <span>角色名:</span> <input type="text" class="form-control" placeholder="角色名" id="name-search">
                        <span style="margin-left: 50px;">有效状态:</span> <!--<input type="text" class="input-medium" placeholder="url" id="url-search">-->
                        <select id="validFlag-search" class="form-control">
                            <option value="true">有效</option>
                            <option value="false">无效</option>
                            <option value="all">全部</option>
                        </select>
                        <div style="float: right;">
                            <button type="button" style="width: 80px" class="btn" id="btn-advanced-search" onclick="search()">
                                <i class="fa fa-search"></i>查询
                            </button>
                            <button style="width: 80px;" type="button" class="btn" id="btn-advanced-add" onclick="addData('${ctx}/role/edit')">
                                <i class="fa fa-add"></i>添加
                            </button>
                        </div>
                    </form>
                    <div class="box">

                        <div class="box-body">
                            <table style="text-align:center" id="roleTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th style="text-align:center">序号</th>
                                    <th style="text-align:center">角色名</th>
                                    <th style="text-align:center">有效状态</th>
                                    <th style="text-align:center">操作</th>
                                </tr>
                                </thead>

                                <#--<tbody>-->
                                <#--<#list roles as role>-->
                                <#--<tr>-->
                                    <#--<td>${role_index+1}</td>-->
                                    <#--<td>${role.name}</td>-->
                                    <#--<td>${role.validFlag}</td>-->
                                    <#--<td>-->
                                        <#--<a href="${ctx}/role/edit?id=${role.id}" >修改</a>&nbsp;&nbsp;&nbsp;&nbsp;-->
                                        <#--<a href="javascript:void(0)" onclick="delRow('${ctx}/role/delete','${role.id}')" >删除</a>-->
                                    <#--</td>-->
                                <#--</tr>-->
                                <#--</#list>-->
                                <#--</tbody>-->

                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>



<#include "../include/foot.ftl"/>
</div>
<!-- ./wrapper -->
<#include "../include/resource.ftl"/>

<script>

    var table;
    var searchFlag=false;

    $(function () {
        //  $('#permTable').DataTable();
        table= $('#roleTable').DataTable({
//           "sPaginationType" : "full_numbers",//设置分页控件的模式
//            "bPaginate": true, //翻页功能
//            "bLengthChange": false, //改变每页显示数据数量
//            "bFilter": false, //过滤功能
//            "bSort": false, //排序功能
//            "bInfo": true,//页脚信息
//            "bAutoWidth": true,//自动宽度
//            "stateSave":true,//设置缓存页页码数据
            "oLanguage": {
                "sLengthMenu": "每页显示 _MENU_ 条记录",
                "sZeroRecords": "抱歉， 没有找到",
                "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
                "sInfoEmpty": "没有数据",
                "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
                "oPaginate": {
                    "sFirst": "首页",
                    "sPrevious": "前一页",
                    "sNext": "后一页",
                    "sLast": "尾页"
                },
                "sZeroRecords": "没有检索到数据",
                "sProcessing": "<img src='./loading.gif' />",
                "sSearch": "搜索"
            },

            "bStateSave" : true,
            "bJQueryUI" : true,
            "bPaginate" : true,// 分页按钮
            "bFilter" : false,// 搜索栏
            "bLengthChange" : false,// 每行显示记录数
            "iDisplayLength" : 10,// 每页显示行数
            "bSort" : false,// 排序
            "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
            "bWidth" : true,
            "bScrollCollapse" : true,
            "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
            //  "bProcessing" : true,
            "bServerSide" : true,
            "bDestroy" : true,
            "bSortCellsTop" : true,
            "sAjaxSource" : "${ctx}/role/list",
            //  "sScrollY": "100%",
            "fnInitComplete": function() {
                this.fnAdjustColumnSizing(true);
            },
            "fnServerParams" : function(aoData) {

                aoData.push({
                    "name" : "name",
                    "value" : encodeURI($("#name-search").val())
                },{
                    "name" : "validFlag",
                    "value" : encodeURI($("#validFlag-search").val())
                }
//               ,{
//                   "name" : "iDisplayStart",
//                   "value" : page
//               }
                );
            },
            "aoColumns" : [
                {"data" :  function(row, type, set, meta) {
                    var c = meta.settings._iDisplayStart + meta.row + 1;
                    return c;
                }},
                {"data" : "name"},
                {"data" : "validFlag"}],

            "aoColumnDefs":[
                {
                    "sClass":"center",
                    "aTargets":[3],
                    "data":"id",
                    "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                        return '<a href=\"javascript:void(0);\" onclick=\"confirmDelete(\''+a+'\')\">删除</a>&nbsp;&nbsp;&nbsp;&nbsp;'
                                + '<a href=\"${ctx}/role/edit?id='+a+'\" >修改</a>';
                    }
                }
            ],
            "fnRowCallback" : function(nRow, aData, iDisplayIndex) {//相当于对字段格式化

            },
            "createdRow": function ( row, data, index ) {
                if ( data['validFlag'] == true ) {
                    $('td', row).eq(2).html('有效');
                }else if(data['validFlag'] == false){
                    $('td', row).eq(2).html('无效');
                }
            },
            "fnServerData" : function(sSource, aoData, fnCallback) {
                var serializeData = function(aoData){
                    var data = {};
                    for(var i = 0 ;i<aoData.length ;i++){
                        var dd = aoData[i];
                        if(dd['value']){
                            data[ dd['name'] ]= dd['value'];
                        }
                    }
                    return $.param(data);

                };

                $.ajax({
                    "type" : 'post',
                    "url" : sSource,
                    //"dataType" : "json",
                    ///"dataSrc": "data",
                    "data" :serializeData(aoData),
                    "success" : function(resp) {
                        fnCallback(resp);
                        var total = $("td");
                        if(total.size()<2 && searchFlag){
                            window.wxc.xcConfirm("很抱歉，系统找不到您的记录，换个条件试试", "info");
                        }
                    }
                });
            }

        });

    });

    function search(){
        //table.draw();
        searchFlag=true;
        table.ajax.reload();
    }


    function addData(url){
        window.location.href=url;
    }

    function confirmDelete(id){
        var url = "${ctx}/role/delete";
        var tipTxt = "温馨提示:删除后无法恢复，是否确定删除？";
        var option = {
            title: "提示",
            btn: parseInt("0011", 2),
            onOk: function () {
                $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data: {id: id},
                })
                        .done(function (data) {
                            window.wxc.xcConfirm(data.message, "success");
                            table.ajax.reload();
                        })
                        .fail(function () {
                            window.wxc.xcConfirm("异常，请联系管理员。", "error");
                        });
            }
        }
        window.wxc.xcConfirm(tipTxt, "confirm", option);
    }

</script>
</body>
</html>
