/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.channel.admin.interceptor;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;
import sinosoftgz.admin.api.AdminMenuApi;
import sinosoftgz.admin.api.AdminUserApi;
import sinosoftgz.admin.sso.AdminUser;
import sinosoftgz.utils.interceptor.BusinessWebInterceptor;

@Component
public class CommonInterceptor
extends BusinessWebInterceptor {
    @MotanReferer(basicReferer="motanClientBasicConfig")
    AdminUserApi adminUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    AdminMenuApi adminMenuApi;

    public void preHandle(WebRequest request) throws Exception {
        if (!SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) {
            return;
        }
        if (!(SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetails)) {
            return;
        }
        UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (userDetails != null) {
            request.setAttribute("user", (Object)this.adminUserApi.findByUsername(userDetails.getUsername()), 0);
        }
        if (request.getHeader("X-Requested-With") == null && request.getAttribute("user", 0) != null) {
            AdminUser user = (AdminUser)request.getAttribute("user", 0);
            List adminMenuList = this.adminMenuApi.loadMenu("login", user.getUsername(), ((DispatcherServletWebRequest)request).getRequest().getRequestURI());
            request.setAttribute("adminMenus", (Object)adminMenuList, 0);
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
    }
}

