/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.channel.admin.web;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.channel.admin.vo.JqueryDataTablesVo;
import sinosoftgz.channel.admin.vo.query.ChannelAgreementQueryVo;
import sinosoftgz.channel.model.ChannelAgreement;
import sinosoftgz.channel.model.ChannelCommissionRate;
import sinosoftgz.channel.service.ChannelAgreementService;
import sinosoftgz.channel.service.ChannelService;
import sinosoftgz.channel.service.CommissionRateService;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.data.DateUtils;
import sinosoftgz.utils.log.Log;
import sinosoftgz.utils.log.Logs;

@Controller
@RequestMapping(value={"/channel-admin/agreement"})
public class AgreementController {
    private static final Log log = Logs.getLog();
    @Autowired
    ChannelAgreementService channelAgreementService;
    @Autowired
    CommissionRateService commissionRateService;
    @Autowired
    ChannelService channelService;

    @RequestMapping(value={"", "list"}, method={RequestMethod.GET})
    public String index() {
        return "agreement/agreementList";
    }

    @RequestMapping(value={"", "agreementList"}, method={RequestMethod.POST})
    @ResponseBody
    public Map channelList(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, ChannelAgreementQueryVo channelAgreementQueryVo, String source) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page agreementPage = null;
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        agreementPage = Lang.isEmpty((Object)channelAgreementQueryVo.getAgreementName()) && Lang.isEmpty((Object)channelAgreementQueryVo.getAgreementNo()) && "5".equals(channelAgreementQueryVo.getZhuangTai()) && "5".equals(channelAgreementQueryVo.getValidStatus()) && Lang.isEmpty((Object)source) ? this.channelAgreementService.getChannelAgreementByPage(pageable) : this.channelAgreementService.getChannelAgreementByParamsAndPage(channelAgreementQueryVo.getAgreementNo(), channelAgreementQueryVo.getAgreementName(), channelAgreementQueryVo.getZhuangTai(), channelAgreementQueryVo.getValidStatus(), pageable, source);
        returnModel.putAll(jqueryDataTablesVo.toMap());
        List agreementlList = agreementPage.getContent();
        ArrayList<ChannelAgreement> agreementlListVo = new ArrayList<ChannelAgreement>();
        ChannelAgreement channelAgreementTemp = new ChannelAgreement();
        Date nowDate = DateUtils.getNowDate();
        for (int i = 0; i < agreementlList.size(); ++i) {
            channelAgreementTemp = (ChannelAgreement)agreementlList.get(i);
            if (nowDate.getTime() < channelAgreementTemp.getValidStartDate().getTime()) {
                channelAgreementTemp.setStatus("1");
            } else if (nowDate.getTime() > DateUtils.getNextDay((Date)channelAgreementTemp.getValidEndDate()).getTime()) {
                channelAgreementTemp.setStatus("3");
            } else if (nowDate.getTime() >= channelAgreementTemp.getValidStartDate().getTime() && nowDate.getTime() <= DateUtils.getNextDay((Date)channelAgreementTemp.getValidEndDate()).getTime()) {
                channelAgreementTemp.setStatus("2");
            }
            agreementlListVo.add(channelAgreementTemp);
        }
        returnModel.put("aaData", agreementlListVo);
        returnModel.put("iTotalRecords", Long.valueOf(agreementPage.getTotalElements()));
        returnModel.put("iTotalDisplayRecords", Long.valueOf(agreementPage.getTotalElements()));
        return returnModel;
    }

    @RequestMapping(value={"edit"})
    public String agreementEdit(String id, Map model) {
        ArrayList commissionList = new ArrayList();
        List channels = null;
        try {
            if (!Lang.isEmpty((Object)id)) {
                ChannelAgreement agreement = this.channelAgreementService.findAgreementById(id);
                List channelCommissions = agreement.getCommissions();
                agreement.setCommissions(channelCommissions);
                if (!Lang.isEmpty((Object)agreement)) {
                    channels = agreement.getChannels();
                }
                model.put("agreement", agreement);
                model.put("channel", channels);
            }
        }
        catch (Exception e) {
            log.info((Object)"\u4fee\u6539\u6e20\u9053\u4fe1\u606f\u9519\u8bef.");
            e.printStackTrace();
        }
        model.put("commissionList", commissionList);
        return "agreement/editAgreement";
    }

    @RequestMapping(value={"add"})
    public String channelAdd(Map model) {
        try {
            List commissionList = this.commissionRateService.getChannelCommissionList();
            model.put("commissionList", commissionList);
        }
        catch (Exception e) {
            log.info((Object)"\u6253\u5f00\u6dfb\u52a0\u534f\u8bae\u9875\u9762\u9519\u8bef");
            e.printStackTrace();
        }
        return "agreement/editAgreement";
    }

    @RequestMapping(value={"saveAgreement"}, method={RequestMethod.POST})
    @ResponseBody
    public Map saveAgreement(ChannelAgreement channelAgreement, String validStartDatetemp, String validEndDatetemp, String inputDatetemp) {
        String responseMessage = "";
        String resultStatus = "success";
        HashMap<String, String> model = new HashMap<String, String>();
        try {
            List commissionListTemp = channelAgreement.getCommissions();
            ArrayList<ChannelCommissionRate> commissionList = new ArrayList<ChannelCommissionRate>();
            if (!Lang.isEmpty((Object)commissionListTemp)) {
                for (int i = 0; i < commissionListTemp.size(); ++i) {
                    ChannelCommissionRate commissionTemp = new ChannelCommissionRate();
                    String classCode = ((ChannelCommissionRate)commissionListTemp.get(i)).getClassName().split("--")[0];
                    String className = ((ChannelCommissionRate)commissionListTemp.get(i)).getClassName().split("--")[1];
                    String riskCode = ((ChannelCommissionRate)commissionListTemp.get(i)).getRiskName().split("--")[0];
                    String riskName = ((ChannelCommissionRate)commissionListTemp.get(i)).getRiskName().split("--")[1];
                    String planCode = ((ChannelCommissionRate)commissionListTemp.get(i)).getPlanName().split("--")[0];
                    String planName = ((ChannelCommissionRate)commissionListTemp.get(i)).getPlanName().split("--")[1];
                    BigDecimal commissionScale = ((ChannelCommissionRate)commissionListTemp.get(i)).getCommissionScale();
                    String insuredType = ((ChannelCommissionRate)commissionListTemp.get(i)).getInsuredType();
                    String commissionId = ((ChannelCommissionRate)commissionListTemp.get(i)).getId();
                    if (!Lang.isEmpty((Object)commissionId)) {
                        commissionTemp.setId(commissionId);
                    }
                    commissionTemp.setClassCode(classCode);
                    commissionTemp.setClassName(className);
                    commissionTemp.setRiskCode(riskCode);
                    commissionTemp.setRiskName(riskName);
                    commissionTemp.setPlanCode(planCode);
                    commissionTemp.setPlanName(planName);
                    commissionTemp.setCommissionScale(commissionScale);
                    commissionTemp.setInsuredType(insuredType);
                    commissionTemp.setAgreement(channelAgreement);
                    commissionList.add(commissionTemp);
                }
            }
            channelAgreement.setCommissions(commissionList);
            if (!Lang.isEmpty((Object)validStartDatetemp)) {
                channelAgreement.setValidStartDate(DateUtils.strToDate((String)validStartDatetemp));
            }
            if (!Lang.isEmpty((Object)validEndDatetemp)) {
                channelAgreement.setValidEndDate(DateUtils.strToDate((String)validEndDatetemp));
            }
            if (!Lang.isEmpty((Object)inputDatetemp)) {
                channelAgreement.setInputDate(DateUtils.strToDate((String)inputDatetemp));
            }
            responseMessage = Lang.isEmpty((Object)channelAgreement.getId()) ? "\u6570\u636e\u6dfb\u52a0\u6210\u529f!" : "\u6570\u636e\u4fee\u6539\u6210\u529f!";
            Map map = this.channelAgreementService.saveChannelAgreement(channelAgreement);
            if (map.get("status").equals("error")) {
                resultStatus = "error";
                responseMessage = "\u6570\u636e\u4fdd\u5b58\u5931\u8d25!";
            }
            model.put("status", resultStatus);
            model.put("message", responseMessage);
        }
        catch (Exception e) {
            model.put("status", "error");
            log.info((Object)"\u4fdd\u5b58\u534f\u8bae\u4fe1\u606f\u9519\u8bef");
            e.printStackTrace();
        }
        return model;
    }

    @RequestMapping(value={"disable"})
    @ResponseBody
    public Map disableChannel(String id) {
        Map<String, String> model = new HashMap<String, String>();
        if (!Lang.isEmpty((Object)id)) {
            model = this.channelAgreementService.disableById(id);
        } else {
            model.put("status", "error");
            model.put("message", "\u6e20\u9053\u7981\u7528\u64cd\u4f5c\u5931\u8d25!");
        }
        return model;
    }
}

