/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.channel.admin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.channel.admin.vo.JqueryDataTablesVo;
import sinosoftgz.channel.admin.vo.query.ChannelQueryVo;
import sinosoftgz.channel.model.ChannelAgreement;
import sinosoftgz.channel.model.ChannelChannel;
import sinosoftgz.channel.service.ChannelAgreementService;
import sinosoftgz.channel.service.ChannelService;
import sinosoftgz.utils.Lang;

@Controller
@RequestMapping(value={"/channel-admin/channel"})
public class ChannelController {
    @Autowired
    ChannelService channelService;
    @Autowired
    ChannelAgreementService channelAgreementService;

    @RequestMapping(value={"/showPrepareNameInput"})
    public String showPrepareNameInput() {
        return "codeinput/PrepareNameInput";
    }

    @RequestMapping(value={"", "list"}, method={RequestMethod.GET})
    public String index() {
        return "channel/channelList";
    }

    @RequestMapping(value={"", "channelList"}, method={RequestMethod.POST})
    @ResponseBody
    public Map channelList(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, ChannelQueryVo channelQueryVo) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page channelPage = null;
        HashMap<String, Object> returnModel = new HashMap<String, Object>();
        channelPage = Lang.isEmpty((Object)channelQueryVo.getChannelCode()) && Lang.isEmpty((Object)channelQueryVo.getChannelName()) && Lang.isEmpty((Object)channelQueryVo.getLinkerName()) && Lang.isEmpty((Object)channelQueryVo.getValidStatus()) ? this.channelService.getChannelByPage(pageable) : this.channelService.getChannelByParamsAndPage(channelQueryVo.getChannelCode(), channelQueryVo.getChannelName(), channelQueryVo.getLinkerName(), channelQueryVo.getValidStatus(), pageable);
        returnModel.putAll(jqueryDataTablesVo.toMap());
        List channelList = channelPage.getContent();
        returnModel.put("aaData", channelList);
        returnModel.put("iTotalRecords", channelPage.getTotalElements());
        returnModel.put("iTotalDisplayRecords", channelPage.getTotalElements());
        return returnModel;
    }

    @RequestMapping(value={"edit"})
    public String channelEdit(String id, Map model) {
        if (StringUtils.isNotBlank((String)id)) {
            ChannelChannel channel = this.channelService.findChannelById(id);
            model.put("channel", channel);
        }
        return "channel/editChannel";
    }

    @RequestMapping(value={"add"})
    public String channelAdd(Map returnMap) {
        return "channel/editChannel";
    }

    @RequestMapping(value={"saveChannel"}, method={RequestMethod.POST})
    @ResponseBody
    public Map saveChannel(ChannelChannel channel, String agreementId, String agreementName) {
        String responseMessage = "";
        String resultStatus = "success";
        ChannelAgreement agreement = new ChannelAgreement();
        if (!Lang.isEmpty((Object)agreementName)) {
            String agreementNo = agreementName.split("--")[0];
            agreement = this.channelAgreementService.findAgreementByAgreementNo(agreementNo);
            channel.setAgreement(agreement);
        }
        responseMessage = Lang.isEmpty((Object)channel.getId()) ? "\u6570\u636e\u6dfb\u52a0\u6210\u529f!" : "\u6570\u636e\u4fee\u6539\u6210\u529f!";
        Map map = this.channelService.saveChannel(channel);
        if (map.get("status").equals("error")) {
            resultStatus = "error";
            responseMessage = "\u6570\u636e\u4fdd\u5b58\u5931\u8d25!";
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("status", resultStatus);
        model.put("message", responseMessage);
        return model;
    }

    @RequestMapping(value={"disable"})
    @ResponseBody
    public Map disableChannel(String id) {
        Map<String, String> model = new HashMap<String, String>();
        if (!Lang.isEmpty((Object)id)) {
            model = this.channelService.disableById(id);
        } else {
            model.put("status", "error");
            model.put("message", "\u6e20\u9053\u7981\u7528\u64cd\u4f5c\u5931\u8d25!");
        }
        return model;
    }
}

