/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.channel.admin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.channel.admin.vo.JqueryDataTablesVo;
import sinosoftgz.channel.model.ChannelCommissionRate;
import sinosoftgz.channel.service.CommissionRateService;
import sinosoftgz.utils.JsonResult;
import sinosoftgz.utils.Lang;

@Controller
@RequestMapping(value={"/channel-admin/commission"})
public class CommissionRateController {
    @Autowired
    CommissionRateService commissionRateService;

    @RequestMapping(value={"", "commissionList"}, method={RequestMethod.POST})
    @ResponseBody
    public Map channelList(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, ChannelCommissionRate channelCommissionRate) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page commissionPage = null;
        HashMap<String, Object> returnModel = new HashMap<String, Object>();
        commissionPage = Lang.isEmpty((Object)channelCommissionRate.getClassCode()) && Lang.isEmpty((Object)channelCommissionRate.getClassName()) ? this.commissionRateService.getChannelCommissionByPage(pageable) : this.commissionRateService.getChannelCommissionByParamsAndPage(channelCommissionRate.getClassCode(), channelCommissionRate.getClassName(), pageable);
        returnModel.putAll(jqueryDataTablesVo.toMap());
        List commissionList = commissionPage.getContent();
        returnModel.put("aaData", commissionList);
        returnModel.put("iTotalRecords", commissionPage.getTotalElements());
        returnModel.put("iTotalDisplayRecords", commissionPage.getTotalElements());
        return returnModel;
    }

    @RequestMapping(value={"", "getCommission"}, method={RequestMethod.POST})
    @ResponseBody
    public String getCommission(String commissionClassCodeStr) {
        String classCode;
        ChannelCommissionRate commission = new ChannelCommissionRate();
        String returnStr = "";
        if (!Lang.isEmpty((Object)commissionClassCodeStr) && !Lang.isEmpty((Object)(classCode = commissionClassCodeStr.split("--")[0]))) {
            commission = this.commissionRateService.findCommissionByClassCode(classCode);
            returnStr = commission.getClassCode() + "-" + commission.getClassName();
        }
        return JsonResult.JSONResp((String)"0", (String)returnStr, (Object)commission);
    }
}

