/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.channel.admin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.channel.admin.vo.JqueryDataTablesVo;
import sinosoftgz.channel.model.ProductPlansRecord;
import sinosoftgz.channel.service.ProductPlansRecordService;
import sinosoftgz.utils.Lang;

@Controller
@RequestMapping(value={"/channel-admin/productPlansRecord"})
public class ProductPlansRecordController {
    @Autowired
    ProductPlansRecordService productPlansRecordService;

    @RequestMapping(value={"", "getByOrderByClaaCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getByOrderByClaaCode(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, ProductPlansRecord productPlansRecord) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page productPlansRecordPage = null;
        HashMap<String, Object> returnModel = new HashMap<String, Object>();
        productPlansRecordPage = Lang.isEmpty((Object)productPlansRecord.getClassName()) && Lang.isEmpty((Object)productPlansRecord.getClassCode()) ? this.productPlansRecordService.getByClassName(pageable) : this.productPlansRecordService.getByParamOrderByClassName(productPlansRecord.getClassCode(), productPlansRecord.getClassName(), pageable);
        List channelList = productPlansRecordPage.getContent();
        returnModel.put("aaData", channelList);
        returnModel.put("iTotalRecords", productPlansRecordPage.getTotalElements());
        returnModel.put("iTotalDisplayRecords", productPlansRecordPage.getTotalElements());
        return returnModel;
    }

    @RequestMapping(value={"", "getByClassCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getBySeacherCode(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, ProductPlansRecord productPlansRecord, String classMessageStr, String riskMessageStr) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page productPlansRecordPage = null;
        HashMap<String, Object> returnModel = new HashMap<String, Object>();
        String seacherCode = classMessageStr.split("--")[0];
        productPlansRecordPage = this.productPlansRecordService.getByClassCode(seacherCode, productPlansRecord.getRiskCode(), productPlansRecord.getRiskName(), pageable);
        List productList = productPlansRecordPage.getContent();
        returnModel.put("aaData", productList);
        returnModel.put("iTotalRecords", productPlansRecordPage.getTotalElements());
        returnModel.put("iTotalDisplayRecords", productPlansRecordPage.getTotalElements());
        return returnModel;
    }

    @RequestMapping(value={"", "getByRiskCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getByRiskCode(Map returnMap, Pageable pageable, JqueryDataTablesVo jqueryDataTablesVo, ProductPlansRecord productPlansRecord, String riskMessageStr) {
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        if (Lang.isEmpty((Object)riskMessageStr)) {
            return null;
        }
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(order1);
        Sort sort = new Sort(orders);
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page productPlansRecordPage = null;
        HashMap<String, Object> returnModel = new HashMap<String, Object>();
        String seacherCode = riskMessageStr.split("--")[0];
        productPlansRecordPage = this.productPlansRecordService.getByRiskCode(seacherCode, productPlansRecord.getPlanCode(), productPlansRecord.getPlanName(), pageable);
        List productList = productPlansRecordPage.getContent();
        returnModel.put("aaData", productList);
        returnModel.put("iTotalRecords", productPlansRecordPage.getTotalElements());
        returnModel.put("iTotalDisplayRecords", productPlansRecordPage.getTotalElements());
        return returnModel;
    }
}

