var table;

$(function () {
    //  $('#permTable').DataTable();
    table= $('#agreementTable').DataTable({
//           "sPaginationType" : "full_numbers",//设置分页控件的模式
//            "bPaginate": true, //翻页功能
//            "bLengthChange": false, //改变每页显示数据数量
//            "bFilter": false, //过滤功能
//            "bSort": false, //排序功能
//            "bInfo": true,//页脚信息
//            "bAutoWidth": true,//自动宽度
//            "stateSave":true,//设置缓存页页码数据
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },

        "bStateSave" : false,
        "bJQueryUI" : true,
        "bPaginate" : true,// 分页按钮
        "bFilter" : false,// 搜索栏
        "bLengthChange" : false,// 每行显示记录数
        "iDisplayLength" : 12,// 每页显示行数
        "bSort" : false,// 排序
        "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth" : true,
        "bScrollCollapse" : true,
        "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        //  "bProcessing" : true,
        "bServerSide" : true,
        "bDestroy" : true,
        "bSortCellsTop" : true,
        "sAjaxSource" : "/channel-admin/agreement/agreementList",
        //  "sScrollY": "100%",
        "fnInitComplete": function() {
            this.fnAdjustColumnSizing(true);
        },
        "fnServerParams" : function(aoData) {

            aoData.push({
                "name" : "agreementNo",
                "value" : $("#agreementNo-search").val()
            },{
                "name" : "agreementName",
                "value" : $("#agreementName-search").val()
            },{
                "name" : "zhuangTai",
                "value" : $("#validFlag-search").val()
            },{
                "name" : "validStatus",
                "value" : $("#shiFouJinYong-search").val()
            });
        },
        "aoColumns" : [
            {"data" :  function(row, type, set, meta) {
                var c = meta.settings._iDisplayStart + meta.row + 1;
                return c;
            }},
            {"data" : "agreementNo"},
            {"data" : "agreementName"},
            {"data" :  function(row, type, set, meta) {
                var validStartDate = row.validStartDate;
                if(validStartDate!=undefined&&validStartDate!=null&&validStartDate!=""){
                    validStartDate =dateFormat(validStartDate);
                }
                var validEndDate = row.validEndDate;
                if(validEndDate!=undefined&&validEndDate!=null&&validEndDate!=""){
                    validEndDate =dateFormat(validEndDate);
                }
                return validStartDate+"--"+validEndDate;
            }},
            {"data" :  function(row, type, set, meta) {
                var status = row.status;
                if(status=="1"){
                    status = "待生效";
                }else if(status=="2"){
                    status = "生效中";
                }else if(status=="3"){
                    status = "已过期";
                }
                return status;
            }},
            {"data" :  function(row, type, set, meta) {
                var validStatus = row.validStatus;
                if(validStatus=="1"){
                    validStatus ="否";
                }else{
                    validStatus ="是";
                }
                return validStatus;
            }}],

        "aoColumnDefs": [
            {
                "sClass": "center",
                "aTargets": [6],
                "data": "id",
                "mRender": function (a, b, c, d) {//id，c表示当前记录行对象
                    var flag=c.validStatus;
                    var strBuffer = "";
                    if(flag=='1'){
                        strBuffer = '<a href=\"'+ctxStr+'/agreement/edit?id=' + a + '\" >修改</a><span style=\"margin:0 10px\"></span>' +
                            '<a href=\"javascript:void(0);\" onclick=\"delRow(\'' + a + '\')\">禁用</a>';
                    }else{
                        strBuffer = '<a href=\"'+ctxStr+'/agreement/edit?id=' + a + '\" >修改</a><span style=\"margin:0 10px\"></span>';
                    }
                    return strBuffer;
                }
            }
        ],
        "fnRowCallback" : function(nRow, aData, iDisplayIndex) {//相当于对字段格式化

        },

        "fnServerData" : function(sSource, aoData, fnCallback) {
            var serializeData = function(aoData){
                var data = {};
                for(var i = 0 ;i<aoData.length ;i++){
                    var dd = aoData[i];
                    if(dd['value']){
                        data[ dd['name'] ]= dd['value'];
                    }
                }
                return $.param(data);
            };
            $.ajax({
                "type" : 'post',
                "url" : sSource,
                //"dataType" : "json",
                ///"dataSrc": "data",
                "data" :serializeData(aoData),
                "success" : function(resp) {
                    if(resp.noDataTip!=undefined&&resp.noDataTip!=null&&resp.noDataTip!=""){
                        window.wxc.xcConfirm(resp.noDataTip, "info",window.wxc.xcConfirm.btnEnum.ok);
                    }
                    fnCallback(resp);
                }
            });
        }

    });

});

//查询
function search() {
    var agreementNo = $("#agreementNo-search").val().trim();
    var agreementName = $("#agreementName-search").val().trim();
    var zhuangTai = $("#validFlag-search").val().trim();
    var validStatus = $("#shiFouJinYong-search").val().trim();
    var tipFlag = false;
    var tipText ="";

    if(tipFlag){
        window.wxc.xcConfirm(tipText, "newCustom", window.wxc.xcConfirm.btnEnum.ok);
        return;
    }
    table.ajax.reload();
}


//根据url跳转至相应页面
function gotoArticleByUrl(url){
    window.location.href =url;
}

//禁用
function delRow(id) {
    var url = ctxStr+"/agreement/disable";
    var tipTxt = "馨提示:您是否确认禁用该条数据？";
    var option = {
        onOk: function () {
            $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data: {id: id},
                })
                .done(function (data) {
                    if (data.status == "success") {
                        window.wxc.xcConfirm(data.message, "success", window.wxc.xcConfirm.btnEnum.ok);
                        table.ajax.reload();
                    }
                })
                .fail(function () {
                    window.wxc.xcConfirm("异常，请联系管理员。", "error");
                    console.log("error");
                });
        }
    }
    window.wxc.xcConfirm(tipTxt, "confirm", option);
}
//Date picker
$('#datepicker-start').datepicker({
    format:'yyyy-mm-dd',
    language: 'cn',
    autoclose: true
});
$('#datepicker-end').datepicker({
    format:'yyyy-mm-dd',
    language: 'cn',
    autoclose: true
});

//格式化时间
function timeFormat(timeStr){
    var dateStr =new Date(timeStr);
    var year =dateStr.getFullYear();
    var month =(dateStr.getMonth()+1)<10?"0"+(dateStr.getMonth()+1):(dateStr.getMonth()+1);
    var day =(dateStr.getDate())<10?"0"+(dateStr.getDate()):(dateStr.getDate());
    var hour =(dateStr.getHours())<10?"0"+(dateStr.getHours()):(dateStr.getHours());
    var minute=(dateStr.getMinutes())<10?"0"+(dateStr.getMinutes()):(dateStr.getMinutes());
    var second =(dateStr.getSeconds())<10?"0"+(dateStr.getSeconds()):(dateStr.getSeconds());
    timeStr =year+"-"+month+"-"+day+" "+hour+":"+minute+":"+second;
    return timeStr;
}
//格式化日期
function dateFormat(timeStr){
    var dateStr =new Date(timeStr);
    var year =dateStr.getFullYear();
    var month =(dateStr.getMonth()+1)<10?"0"+(dateStr.getMonth()+1):(dateStr.getMonth()+1);
    var day =(dateStr.getDate())<10?"0"+(dateStr.getDate()):(dateStr.getDate());
    dateStr =year+"-"+month+"-"+day;
    return dateStr;
}
////根据有效时间得到状态
//function  getValidFlag(startDate,endDate){
//
//    var nowDate = new Date();
//    var startDatetemp = new Date(startDate);
//    var endDatetemp = new Date(endDate);
//    if(nowDate<startDatetemp){
//        return "待生效";
//    }else if(nowDate>endDatetemp){
//        return "已过期";
//    }else if(nowDate>startDatetemp&&nowDate<endDatetemp){
//        return "生效中";
//    }
//
//}

function getDay(day){
    var today = new Date();

    var targetday_milliseconds=today.getTime() + 1000*60*60*24*day;

    today.setTime(targetday_milliseconds); //注意，这行是关键代码

    var tYear = today.getFullYear();
    var tMonth = today.getMonth();
    var tDate = today.getDate();
    tMonth = doHandleMonth(tMonth + 1);
    tDate = doHandleMonth(tDate);
    return tYear+"-"+tMonth+"-"+tDate;
}
function doHandleMonth(month){
    var m = month;
    if(month.toString().length == 1){
        m = "0" + month;
    }
    return m;
}

//判断两个日期的大小
function judgeDate(date1,date2){
    var oDate1 = new Date(date1);
    var oDate2 = new Date(date2);
    if(oDate1.getTime() >= oDate2.getTime()){
        return true;
    } else {
        return false;
    }
}



function addDate(url){
    window.location.href=url;
}

function turnToIndex(){
    window.location.href =ctxStr+"/agreement/list";
}