var table;

$(function () {
    //  $('#permTable').DataTable();
    table= $('#channelTable').DataTable({
//           "sPaginationType" : "full_numbers",//设置分页控件的模式
//            "bPaginate": true, //翻页功能
//            "bLengthChange": false, //改变每页显示数据数量
//            "bFilter": false, //过滤功能
//            "bSort": false, //排序功能
//            "bInfo": true,//页脚信息
//            "bAutoWidth": true,//自动宽度
//            "stateSave":true,//设置缓存页页码数据
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },

        "bStateSave" : false,
        "bJQueryUI" : true,
        "bPaginate" : true,// 分页按钮
        "bFilter" : false,// 搜索栏
        "bLengthChange" : false,// 每行显示记录数
        "iDisplayLength" : 12,// 每页显示行数
        "bSort" : false,// 排序
        "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth" : true,
        "bScrollCollapse" : true,
        "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        //  "bProcessing" : true,
        "bServerSide" : true,
        "bDestroy" : true,
        "bSortCellsTop" : true,
        "sAjaxSource" : "/channel-admin/channel/channelList",
        //  "sScrollY": "100%",
        "fnInitComplete": function() {
            this.fnAdjustColumnSizing(true);
        },
        "fnServerParams" : function(aoData) {

            aoData.push({
                "name" : "channelCode",
                "value" : $("#channelCode-search").val()
            },{
                "name" : "channelName",
                "value" : $("#channelName-search").val()
            },{
                "name" : "linkerName",
                "value" : $("#linkerName-search").val()
            },{
                "name" : "validStatus",
                "value" : $("#validStatus-search").val()
            });
        },
        "aoColumns" : [
            {"data" :  function(row, type, set, meta) {
                var c = meta.settings._iDisplayStart + meta.row + 1;
                return c;
            }},
            {"data" : "channelCode"},
            {"data" : "channelName"},
            {"data" : "linkerName"},
            {"data" :  function(row, type, set, meta) {
                var validStatus = row.validStatus;
                if(validStatus=="1"){
                    validStatus ="否";
                }else{
                    validStatus ="是";
                }
                return validStatus;
            }}],

        "aoColumnDefs": [
            {
                "sClass": "center",
                "aTargets": [5],
                "data": "id",
                "mRender": function (a, b, c, d) {//id，c表示当前记录行对象
                    var flag=c.validStatus;
                    var strBuffer = "";
                    if(flag=='1'){
                        strBuffer = '<a href=\"'+ctxStr+'/channel/edit?id=' + a + '\" >修改</a><span style=\"margin:0 10px\"></span>' +
                            '<a href=\"javascript:void(0);\" onclick=\"delRow(\'' + a + '\')\">禁用</a>';
                    }else{
                        strBuffer = '<a href=\"'+ctxStr+'/channel/edit?id=' + a + '\" >修改</a><span style=\"margin:0 10px\"></span>';
                    }
                    return strBuffer;
                }
            }
        ],
        "fnRowCallback" : function(nRow, aData, iDisplayIndex) {//相当于对字段格式化

        },

        "fnServerData" : function(sSource, aoData, fnCallback) {
            var serializeData = function(aoData){
                var data = {};
                for(var i = 0 ;i<aoData.length ;i++){
                    var dd = aoData[i];
                    if(dd['value']){
                        data[ dd['name'] ]= dd['value'];
                    }
                }
                return $.param(data);
            };
            $.ajax({
                "type" : 'post',
                "url" : sSource,
                //"dataType" : "json",
                ///"dataSrc": "data",
                "data" :serializeData(aoData),
                "success" : function(resp) {
                    if(resp.noDataTip!=undefined&&resp.noDataTip!=null&&resp.noDataTip!=""){
                        window.wxc.xcConfirm(resp.noDataTip, "info",window.wxc.xcConfirm.btnEnum.ok);
                    }
                    fnCallback(resp);
                }
            });
        }

    });

});

//查询
function search() {

    table.ajax.reload();
}


//根据url跳转至相应页面
function gotoArticleByUrl(url){
    window.location.href =url;
}

//禁用
function delRow(id) {
    var url = ctxStr+"/channel/disable";
    var tipTxt = "馨提示:您是否确认禁用该条数据？";
    var option = {
        onOk: function () {
            $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data: {id: id},
                })
                .done(function (data) {
                    if (data.status == "success") {
                        window.wxc.xcConfirm(data.message, "success", window.wxc.xcConfirm.btnEnum.ok);
                        table.ajax.reload();
                    }
                })
                .fail(function () {
                    window.wxc.xcConfirm("异常，请联系管理员。", "error");
                    console.log("error");
                });
        }
    }
    window.wxc.xcConfirm(tipTxt, "confirm", option);
}
//Date picker
$('#datepicker-start').datepicker({
    format:'yyyy-mm-dd',
    language: 'cn',
    autoclose: true
});
$('#datepicker-end').datepicker({
    format:'yyyy-mm-dd',
    language: 'cn',
    autoclose: true
});

//格式化时间
function timeFormat(timeStr){
    var dateStr =new Date(timeStr);
    var year =dateStr.getFullYear();
    var month =(dateStr.getMonth()+1)<10?"0"+(dateStr.getMonth()+1):(dateStr.getMonth()+1);
    var day =(dateStr.getDate())<10?"0"+(dateStr.getDate()):(dateStr.getDate());
    var hour =(dateStr.getHours())<10?"0"+(dateStr.getHours()):(dateStr.getHours());
    var minute=(dateStr.getMinutes())<10?"0"+(dateStr.getMinutes()):(dateStr.getMinutes());
    var second =(dateStr.getSeconds())<10?"0"+(dateStr.getSeconds()):(dateStr.getSeconds());
    timeStr =year+"-"+month+"-"+day+" "+hour+":"+minute+":"+second;
    return timeStr;
}
//格式化日期
function dateFormat(timeStr){
    var dateStr =new Date(timeStr);
    var year =dateStr.getFullYear();
    var month =(dateStr.getMonth()+1)<10?"0"+(dateStr.getMonth()+1):(dateStr.getMonth()+1);
    var day =(dateStr.getDate())<10?"0"+(dateStr.getDate()):(dateStr.getDate());
    dateStr =year+"-"+month+"-"+day;
    return dateStr;
}




function addDate(url){
    window.location.href=url;
}

function turnToIndex(){
    window.location.href =ctxStr+"/channel/list";
}