
function turnToIndex(){
    window.location.href =ctxStr+"/channel/list";
}

//调用
$(document).ready(function(){
    $('#channelForm').bind('submit', function(){
        ajaxSubmit(this, function(data){
            if (data.status == "success") {
                var txt=  data.message;
                var option = {
                    onOk: function(){
                        turnToIndex();
                    }
                }
                window.wxc.xcConfirm(txt, "success", option);
                setTimeout(function () {
                    turnToIndex();
                }, 5000);
            }
        });
        return false;
    });
});

//将form转为AJAX提交
function ajaxSubmit(frm, fn) {
    var dataPara = getFormJson(frm);
    $.ajax({
        url: frm.action,
        type: frm.method,
        data: dataPara,
        success: fn
    });

}

//将form中的值转换为键值对。
function getFormJson(frm) {
    var o = {};
    var a = $(frm).serializeArray();
    $.each(a, function () {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });

    return o;
}
$(function(){

});


function addAttr(){
    $("#agreementName").attr("data-target","#myModal");
    $("#agreementName").click();

    $('#agreementTable tr:eq(1)').attr('id','trSelected');//为第一行默认选中
    $('#agreementTable tr:eq(1)').addClass('s1');
    $("#agreementTable tbody tr").on("click",function(){
        $("#agreementTable tr").each(function(){
            $(this).removeAttr('id');
            $(this).removeClass('s1');
        });
        $(this).attr('id','trSelected');
        $(this).addClass('s1'); //为选中项添加高亮
    });

}

function removeAttr(){
    $("#agreementName").removeAttr("data-target");
        $("#agreementTable tr").each(function() {
            $(this).removeAttr('id');
            $(this).removeClass('s1');
        });
}

function getAgreementStr(){
    var agreementStr = $("#trSelected").find("td:first").text();
    if(agreementStr!="没有检索到数据"){
        $("#agreementName").val(agreementStr);
    }

    $("#agreementName").removeAttr("data-target");
}

var table;

$(function () {
    table= $('#agreementTable').DataTable({
//
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },

        "bStateSave" : false,
        "bJQueryUI" : true,
        "bPaginate" : true,// 分页按钮
        "bFilter" : false,// 搜索栏
        "bLengthChange" : false,// 每行显示记录数
        "iDisplayLength" : 15,// 每页显示行数
        "bSort" : false,// 排序
        "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth" : true,
        "bScrollCollapse" : true,
        "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        //  "bProcessing" : true,
        "bServerSide" : true,
        "bDestroy" : true,
        "bSortCellsTop" : true,
        "sAjaxSource" : "/channel-admin/agreement/agreementList",
        //  "sScrollY": "100%",
        "fnInitComplete": function() {
            this.fnAdjustColumnSizing(true);
        },
        "fnServerParams" : function(aoData) {

            aoData.push({
                "name" : "agreementNo",
                "value" : $("#agreementNo-search").val()
            },{
                "name" : "source",
                "value" : "editChannel"
            },{
                "name" : "agreementName",
                "value" : $("#agreementName-search").val()
            });
        },
        "aoColumns" : [
            {"data" :  function(row, type, set, meta) {
                var agreementNo = row.agreementNo;
                var agreementName = row.agreementName;
                return agreementNo+"--"+agreementName;
            }}],
        "fnRowCallback" : function(nRow, aData, iDisplayIndex) {//相当于对字段格式化
        },

        "fnServerData" : function(sSource, aoData, fnCallback) {
            var serializeData = function(aoData){
                var data = {};
                for(var i = 0 ;i<aoData.length ;i++){
                    var dd = aoData[i];
                    if(dd['value']){
                        data[ dd['name'] ]= dd['value'];
                    }
                }
                return $.param(data);
            };
            $.ajax({
                "type" : 'post',
                "url" : sSource,
                //"dataType" : "json",
                ///"dataSrc": "data",
                "data" :serializeData(aoData),
                "success" : function(resp) {
                    if(resp.noDataTip!=undefined&&resp.noDataTip!=null&&resp.noDataTip!=""){
                        window.wxc.xcConfirm(resp.noDataTip, "info",window.wxc.xcConfirm.btnEnum.ok);
                    }
                    fnCallback(resp);
                    //setTimeout(function () {
                        $('#agreementTable tr:eq(1)').attr('id','trSelected');//为第一行默认选中
                        $('#agreementTable tr:eq(1)').addClass('s1');
                        $("#agreementTable tbody tr").on("click",function(){
                            $("#agreementTable tr").each(function(){
                                $(this).removeAttr('id');
                                $(this).removeClass('s1');

                            });
                            $(this).attr('id','trSelected');
                            $(this).addClass('s1'); //为选中项添加高亮
                        });
                    //}, 1500);
                }
            });

        }

    });
});

//查询
function search() {
    var agreementNo = $("#agreementNo-search").val().trim();
    var agreementName = $("#agreementName-search").val().trim();
    table.ajax.reload();

}





