/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.admin.schedule;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import sinosoftgz.gateway.model.GatewayClientTrafficStatistic;
import sinosoftgz.gateway.repository.GatewayClientTrafficStatisticDao;

@Service
public class ClientTrafficStatisticRunner {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    GatewayClientTrafficStatisticDao gatewayClientTrafficStatisticDao;
    static final Logger logger = LoggerFactory.getLogger(ClientTrafficStatisticRunner.class);

    public void run() {
        logger.info("ClientTrafficStatisticRunner is run");
        Set keys = this.stringRedisTemplate.keys((Object)"rateLimiter:*");
        for (String key : keys) {
            Long visitCount = Long.valueOf((String)this.stringRedisTemplate.boundValueOps((Object)key).get());
            String[] multiValues = key.split(":")[1].split("&|(\\?)");
            GatewayClientTrafficStatistic gatewayClientTrafficStatistic = new GatewayClientTrafficStatistic();
            gatewayClientTrafficStatistic.setUrl(multiValues[0]);
            gatewayClientTrafficStatistic.setClientId(multiValues[1].split("=")[1]);
            gatewayClientTrafficStatistic.setVisitDate(new Date(1000L * Long.valueOf(multiValues[3].split("=")[1]) * Long.valueOf(multiValues[2].split("=")[1])));
            gatewayClientTrafficStatistic.setTimeUnit(Long.valueOf(multiValues[3].split("=")[1]));
            gatewayClientTrafficStatistic.setVisitCount(visitCount);
            this.gatewayClientTrafficStatisticDao.save((Object)gatewayClientTrafficStatistic);
        }
        this.stringRedisTemplate.delete((Collection)keys);
    }
}

