/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.admin.web.gateway;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import sinosoftgz.apiGateway.admin.web.gateway.service.ClientConfigRelationService;
import sinosoftgz.apiGateway.admin.web.user.service.UserService;
import sinosoftgz.channel.api.ChannelApi;
import sinosoftgz.channel.model.ChannelChannel;
import sinosoftgz.gateway.model.GatewayClientConfigRelation;
import sinosoftgz.gateway.vo.GatewayClientConfigVO;
import sinosoftgz.utils.Lang;

@Controller
@RequestMapping(value={"/gateway-admin/gatewayConfig"})
public class GatewayConfigController {
    @Autowired
    ClientConfigRelationService clientConfigRelationService;
    @Autowired
    UserService userService;
    @MotanReferer
    ChannelApi channelApi;

    @RequestMapping(value={"/list.html"})
    public String list(String clientId, Map model) {
        List users = this.userService.findAll();
        model.put("users", users);
        List channels = this.channelApi.getChannelList();
        HashMap<String, String> channelMap = new HashMap<String, String>();
        for (ChannelChannel channel : channels) {
            channelMap.put(channel.getId(), channel.getChannelName());
        }
        if (!Lang.isEmpty((Object)clientId)) {
            GatewayClientConfigVO configvo = this.clientConfigRelationService.getClientConfigVO(clientId);
            model.put("configvo", configvo);
            model.put("clientId", clientId);
            model.put("clientChannelName", channelMap.get(configvo.getUser().getChannel()));
        }
        model.put("channelMap", channelMap);
        return "configure/gateway";
    }

    @RequestMapping(value={"/disable.do"})
    public String disable(String id, String clientId) {
        this.clientConfigRelationService.removeByConfigId(id);
        return "redirect:/gatewayConfig/list.html?clientId=" + clientId;
    }

    @RequestMapping(value={"/publishConfig.do"})
    public String publishConfig(GatewayClientConfigRelation gatewayClientConfigRelation) {
        this.clientConfigRelationService.save(gatewayClientConfigRelation);
        return "redirect:/gatewayConfig/list.html?clientId=" + gatewayClientConfigRelation.getClientId();
    }
}

