/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.admin.web.gateway.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import sinosoftgz.gateway.model.GatewayApiDefine;
import sinosoftgz.gateway.model.GatewayClientConfigRelation;
import sinosoftgz.gateway.model.GatewayOauthClientDetails;
import sinosoftgz.gateway.model.GatewayRateLimit;
import sinosoftgz.gateway.repository.GatewayApiDefineDao;
import sinosoftgz.gateway.repository.GatewayClientConfigRelationDao;
import sinosoftgz.gateway.repository.GatewayOauthClientDetailsDao;
import sinosoftgz.gateway.repository.GatewayRateLimitDao;
import sinosoftgz.gateway.vo.GatewayApiDefineAndRateLimitVO;
import sinosoftgz.gateway.vo.GatewayClientConfigVO;
import sinosoftgz.utils.Lang;

@Service
public class ClientConfigRelationService {
    @Autowired
    GatewayOauthClientDetailsDao clientDetailsDao;
    @Autowired
    GatewayApiDefineDao gatewayApiDefineDao;
    @Autowired
    GatewayRateLimitDao gatewayRateLimitDao;
    @Autowired
    GatewayClientConfigRelationDao clientConfigRelationDao;
    @Autowired
    StringRedisTemplate redisTemplate;

    public GatewayClientConfigVO getClientConfigVO(String clientId) {
        GatewayClientConfigVO gatewayClientConfigVO = new GatewayClientConfigVO();
        GatewayOauthClientDetails clientDetails = (GatewayOauthClientDetails)this.clientDetailsDao.findOne((Serializable)((Object)clientId));
        gatewayClientConfigVO.setUser(clientDetails);
        List allGatewayRateLimits = this.gatewayRateLimitDao.findAll();
        ArrayList<GatewayRateLimit> gatewayRateLimits = new ArrayList<GatewayRateLimit>();
        ArrayList<GatewayRateLimit> gatewayTimesLimits = new ArrayList<GatewayRateLimit>();
        for (GatewayRateLimit allGatewayRateLimit : allGatewayRateLimits) {
            if (allGatewayRateLimit.getType() == 1) {
                gatewayRateLimits.add(allGatewayRateLimit);
                continue;
            }
            gatewayTimesLimits.add(allGatewayRateLimit);
        }
        gatewayClientConfigVO.setGatewayRateLimits(allGatewayRateLimits);
        List clientConfigRelations = this.clientConfigRelationDao.findByClientId(clientId);
        HashMap<String, GatewayClientConfigRelation> clientConfigRelationMap = new HashMap<String, GatewayClientConfigRelation>();
        for (GatewayClientConfigRelation clientConfigRelation : clientConfigRelations) {
            clientConfigRelationMap.put(clientConfigRelation.getApiDefineId(), clientConfigRelation);
        }
        ArrayList<GatewayApiDefineAndRateLimitVO> gatewayApiDefineAndRateLimitVOs = new ArrayList<GatewayApiDefineAndRateLimitVO>();
        gatewayClientConfigVO.setGatewayApiDefineAndRateLimitVOs(gatewayApiDefineAndRateLimitVOs);
        List apiDefines = this.gatewayApiDefineDao.findAll();
        for (GatewayApiDefine apiDefine : apiDefines) {
            GatewayApiDefineAndRateLimitVO apiDefineAndRateLimitVO = new GatewayApiDefineAndRateLimitVO();
            apiDefineAndRateLimitVO.setGatewayApiDefine(apiDefine);
            GatewayClientConfigRelation clientConfigRelation = (GatewayClientConfigRelation)clientConfigRelationMap.get(apiDefine.getId());
            if (!Lang.isEmpty((Object)clientConfigRelation)) {
                for (GatewayRateLimit rateLimit : gatewayRateLimits) {
                    if (!rateLimit.getId().equals(clientConfigRelation.getRateLimitId())) continue;
                    apiDefineAndRateLimitVO.setGatewayRateLimit(rateLimit);
                    break;
                }
                for (GatewayRateLimit timesLimit : gatewayTimesLimits) {
                    if (!timesLimit.getId().equals(clientConfigRelation.getTimeLimitId())) continue;
                    apiDefineAndRateLimitVO.setGatewayTimesLimit(timesLimit);
                    break;
                }
                apiDefineAndRateLimitVO.setEnabled(true);
                apiDefineAndRateLimitVO.setConfigId(clientConfigRelation.getId());
            }
            gatewayApiDefineAndRateLimitVOs.add(apiDefineAndRateLimitVO);
        }
        return gatewayClientConfigVO;
    }

    public void removeByConfigId(String configId) {
        GatewayClientConfigRelation config = (GatewayClientConfigRelation)this.clientConfigRelationDao.findOne((Serializable)((Object)configId));
        if (!Lang.isEmpty((Object)config)) {
            String key = config.getClientId() + ":" + config.getApiDefineId();
            this.clientConfigRelationDao.delete((Serializable)((Object)configId));
            this.redisTemplate.convertAndSend("disableRateLimitPlan", (Object)key);
            this.resetClientAuthorities(config.getClientId());
        }
    }

    public void save(GatewayClientConfigRelation gatewayClientConfigRelation) {
        GatewayClientConfigRelation result = (GatewayClientConfigRelation)this.clientConfigRelationDao.save((Object)gatewayClientConfigRelation);
        this.redisTemplate.convertAndSend("publishRateLimitPlan", (Object)result.getId());
        this.resetClientAuthorities(gatewayClientConfigRelation.getClientId());
    }

    private void resetClientAuthorities(String clientId) {
        List configvos = this.clientConfigRelationDao.findByClientId(clientId);
        List apiDefines = this.gatewayApiDefineDao.findAll();
        HashMap<String, String> apiDefineMap = new HashMap<String, String>();
        for (GatewayApiDefine apiDefine : apiDefines) {
            apiDefineMap.put(apiDefine.getId(), apiDefine.getRole());
        }
        StringBuffer authorities = new StringBuffer();
        for (int i = 0; i < configvos.size(); ++i) {
            String role = (String)apiDefineMap.get(((GatewayClientConfigRelation)configvos.get(i)).getApiDefineId());
            if (i == 0) {
                authorities.append("ROLE_").append(role);
                continue;
            }
            authorities.append(",ROLE_").append(role);
        }
        GatewayOauthClientDetails user = (GatewayOauthClientDetails)this.clientDetailsDao.findOne((Serializable)((Object)clientId));
        user.setAuthorities(authorities.toString());
        this.clientDetailsDao.save((Object)user);
        this.redisTemplate.convertAndSend("refreshMetaSourceChannel", (Object)clientId);
    }
}

