CREATE TABLE gateway_users (
  username varchar(50) NOT NULL PRIMARY KEY,
  password varchar(500) NOT NULL,
  enabled BOOLEAN NOT NULL
);
CREATE TABLE gateway_authorities (
  username varchar(50) NOT NULL,
  authority varchar(50) NOT NULL,
  CONSTRAINT gateway_fk_authorities_users FOREIGN KEY (username) REFERENCES gateway_users (username)
);
CREATE UNIQUE INDEX gateway_ix_auth_username
  ON gateway_authorities (username, authority);

CREATE TABLE gateway_groups (
  id BIGINT PRIMARY KEY  AUTO_INCREMENT,
  group_name varchar(50) NOT NULL
);
CREATE TABLE gateway_group_authorities (
  group_id  BIGINT      NOT NULL,
  authority VARCHAR(50) NOT NULL,
  CONSTRAINT gateway_fk_group_authorities_group FOREIGN KEY (group_id) REFERENCES gateway_groups (id)
);
CREATE TABLE gateway_group_members (
  id       BIGINT  PRIMARY KEY  AUTO_INCREMENT,
  username VARCHAR(50) NOT NULL,
  group_id BIGINT      NOT NULL,
  CONSTRAINT gateway_fk_group_members_group FOREIGN KEY (group_id) REFERENCES gateway_groups (id)
);


create table gateway_persistent_logins (
  username varchar(64) not null,
  series varchar(64) primary key,
  token varchar(64) not null,
  last_used timestamp not null
);