<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>网关配置平台</title>
<#include "../include/head.ftl" />
    <style type="text/css">
        td {
            text-align: center;
        }

        th {
            text-align: center;
        }
        .doublebg {
            background-color: #1ab7ea;
        }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper" id="main-containter">
<#include "../include/top-menu.ftl"/>
    <!-- Left side column. contains the logo and sidebar -->
<#include "../include/left.ftl"/>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                网关配置
            </h1>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <span>渠道:</span>
                    <input type="text" id="channel"  <#if configvo??> value="${clientChannelName!}" </#if>  data-target="#channelModal"  class="form-inline well" name="channel" data-toggle="modal" ondblclick="addAttr();"  placeholder="请选择渠道"/>
                </div>
                <#if configvo??>
                    <div class="col-xs-12">
                        <span>客户信息</span>
                        <div>渠道名称：  ${clientChannelName!}</div>
                        <div>客户端编号：  ${configvo.user.clientId}</div>
                    </div>
                </#if>
                <div class="col-xs-12">
                    <form class="form-inline well" id="product-query-form">
                        <span>接口代码:</span>
                        <input style="margin-right: 10px" type="text" class="input-medium" query-param="agreementNo"
                               name="" placeholder="">
                        <span>接口名称:</span>
                        <input style="margin-right: 10px" type="text" class="input-medium" query-param="agreementName"
                               name="" placeholder="">

                        <span>是否启用:</span>
                        <select class="form-control">
                            <option>是</option>
                            <option>否</option>
                        </select>

                        <div style="float: right">
                            <button type="button" class="btn" id="btn-advanced-search" onclick="search()">
                                <i class="fa fa-search"></i>查询
                            </button>
                        </div>
                    </form>
                    <div class="box">
                    <#--<div class="box-header">
                        <h3 class="box-title">协议管理</h3>
                    </div>-->
                        <!-- /.box-header -->
                        <input type="hidden" id="globalClientId" value="${clientId!}">
                        <div class="box-body">
                            <table id="agreementTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>序号</th>
                                    <th>接口代码</th>
                                    <th>接口名称</th>
                                    <th>PATH</th>
                                    <th>url</th>
                                    <th>限流方案</th>
                                    <th>配额方案</th>
                                    <th>启用状态</th>
                                    <th>操作</th>
                                </tr>
                                </thead>
                                <tbody>
                                <#if configvo??>
                                <#list configvo.gatewayApiDefineAndRateLimitVOs?if_exists as gatewayApiDefineAndRateLimitVO>
                                <form method="post" action="${ctx}/gatewayConfig/publishConfig.do">
                                    <input type="hidden" name="id" value="${gatewayApiDefineAndRateLimitVO.configId!}">
                                    <input type="hidden" name="clientId" value="${clientId!}">
                                    <input type="hidden" name="apiDefineId" value="${gatewayApiDefineAndRateLimitVO.gatewayApiDefine.id!}">
                                    <tr target="sid_proxy">
                                    <td class="center" style="width: 5%;">
                                        <div>${gatewayApiDefineAndRateLimitVO_index+1}</div>
                                    </td>
                                    <td class="center">${gatewayApiDefineAndRateLimitVO.gatewayApiDefine.role!}</td>
                                    <td class="center">${gatewayApiDefineAndRateLimitVO.gatewayApiDefine.apiName!}</td>
                                    <td class="center">${gatewayApiDefineAndRateLimitVO.gatewayApiDefine.path!}</td>
                                    <td class="center">${gatewayApiDefineAndRateLimitVO.gatewayApiDefine.url!}</td>
                                    <td class="center">
                                        <#if gatewayApiDefineAndRateLimitVO.gatewayRateLimit??>
                                            <select class="form-control" name="rateLimitId">
                                                <option value="">不限流</option>
                                                <#list configvo.gatewayRateLimits as ratelimit>
                                                    <#if ratelimit.type==1>
                                                        <option <#if gatewayApiDefineAndRateLimitVO.gatewayRateLimit.id==ratelimit.id> selected = "selected" </#if> value='${ratelimit.id}' >${ratelimit.name}</option>
                                                    </#if>
                                                </#list>
                                            </select>
                                        <#else>
                                            <select class="form-control" name="rateLimitId">
                                                <option selected = "selected" value="">不限流</option>
                                                <#list configvo.gatewayRateLimits as ratelimit>
                                                    <#if ratelimit.type==1>
                                                        <option value='${ratelimit.id}'>${ratelimit.name}</option>
                                                    </#if>
                                                </#list>
                                            </select>
                                        </#if>
                                    </td>
                                    <td class="center">
                                        <#if gatewayApiDefineAndRateLimitVO.gatewayTimesLimit??>
                                            <select class="form-control" name="timeLimitId">
                                                <option value="">不配额</option>
                                                <#list configvo.gatewayRateLimits as timeslimit>
                                                    <#if timeslimit.type==2>
                                                        <option <#if gatewayApiDefineAndRateLimitVO.gatewayTimesLimit.id==timeslimit.id> selected = "selected" </#if> value='${timeslimit.id}' >${timeslimit.name}</option>
                                                    </#if>
                                                </#list>
                                            </select>
                                        <#else>
                                            <select class="form-control" name="timeLimitId">
                                                <option selected = "selected" value="">不配额</option>
                                                <#list configvo.gatewayRateLimits as timeslimit>
                                                    <#if timeslimit.type==2>
                                                        <option value='${timeslimit.id}'>${timeslimit.name}</option>
                                                    </#if>
                                                </#list>
                                            </select>
                                        </#if>
                                    </td>
                                    <td class="center">
                                        <#if gatewayApiDefineAndRateLimitVO.enabled>
                                            启用
                                        <#else>
                                            禁用
                                        </#if>
                                    </td>
                                    <td class="center">
                                        <#if gatewayApiDefineAndRateLimitVO.configId??>
                                            <input onclick=disableConfig('${gatewayApiDefineAndRateLimitVO.configId!}','${clientId!}') class="edit" value="禁用" type="button"/>
                                        </#if>
                                            <input class="edit" value="发布" type="submit" />
                                    </td>
                                </tr>
                                </form>
                                </#list>
                                </#if>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </section>
    </div>
    <!-- /.content-wrapper -->
<#include "../include/foot.ftl"/>
<#include "channelModal.ftl"/>
</div>
<!-- ./wrapper -->
<#include "../include/resource.ftl"/>

<script type="text/javascript">

    function disableConfig(id,clientId){
        window.location.href="${ctx}/gatewayConfig/disable.do?id="+id+"&clientId="+clientId;
    }

    //双击域
    function addAttr(){
        $("#channel").attr("data-target","#channelModal");
        $("#channel").click();
    }
    function removeAttr(){
        $("#channel").removeAttr("data-target");
    }
    function bindClientId(clientId){
        $("#globalClientId").val(clientId);
        $("#"+clientId).css("background","#5eb4ca");
        $("#"+clientId).siblings().css("background","");
    }
    function listByClientId(){
        var clientId = $("#globalClientId").val();
        if(clientId != null && clientId !=""){
            location.href="${ctx}/gatewayConfig/list.html?clientId="+clientId;
        }

    }

</script>
</body>
</html>
