
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>请登录</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="${c_static}/lte/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="${c_static}/lte/awesome-font/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="${c_static}/lte/ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="${c_static}/lte/dist/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="${c_static}/lte/plugins/iCheck/square/blue.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="${c_static}/lte/public/js/html5shiv.min.js"></script>
    <script src="${c_static}/lte/public/js/respond.min.js"></script>
    <![endif]-->
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="login-logo">
        <b>集采统一管理后台</b>
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">
        <p class="login-box-msg">请输入用户密码登录</p>
    <#if shiroLoginFailure??>
        <#if shiroLoginFailure == "org.apache.shiro.authc.UnknownAccountException">
            <span class="text-red">您输入的账户不存在，请核实!</span>
        <#elseif shiroLoginFailure == "org.apache.shiro.authc.IncorrectCredentialsException">
            <span class="text-red">您输入的密码有误!</span>
        <#elseif shiroLoginFailure == "org.apache.shiro.authc.DisabledAccountException">
            <span class="text-red">管理员无效，不可登录系统!</span>
        </#if>

    </#if>
        <form action="${ctx}/login" method="post">
            <div class="form-group has-feedback">
                <input type="text" class="form-control" name="username" placeholder="请输入您的账号">
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            <#if shiroLoginFailure??>
                <#if shiroLoginFailure == "org.apache.shiro.authc.pam.UnsupportedTokenException">
                    <span class="text-red" style="margin-top:-10px">账户名不能为空!</span>
                </#if>
            </#if>
            </div>

            <div class="form-group has-feedback">
                <input type="password" name="password" class="form-control" placeholder="请输入您的密码">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
            <#if shiroLoginFailure??>
                <#if shiroLoginFailure == "org.apache.shiro.authc.CredentialsException">
                    <span class="text-red">密码不能为空!</span>
                </#if>
            </#if>
            </div>

            <div class="row">
                <div class="col-xs-8">
                    <div class="checkbox icheck">
                    <#--<label>
                            <input type="checkbox"> Remember Me
                        </label>-->
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xs-4">
                    <button type="submit" class="btn btn-primary btn-block btn-flat">登录</button>
                </div>
                <!-- /.col -->
            </div>
        </form>

    </div>
    <!-- /.login-box-body -->
</div>
<!-- /.login-box -->

<!-- jQuery 2.2.3 -->
<script src="${c_static}/lte/plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="${c_static}/lte/bootstrap/js/bootstrap.min.js"></script>
<!-- iCheck -->
<script src="${c_static}/lte/plugins/iCheck/icheck.min.js"></script>
<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>
</body>
</html>
