<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>网关配置平台</title>
<#include "../include/head.ftl" />
    <style type="text/css">
        td {
            text-align: center;
        }

        th {
            text-align: center;
        }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper" id="main-containter">
<#include "../include/top-menu.ftl"/>
    <!-- Left side column. contains the logo and sidebar -->
<#include "../include/left.ftl"/>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                配额方案
            </h1>
            <ol class="breadcrumb">
                <li><a href="${ctx}"><i class="fa fa-dashboard"></i> 配额方案</a></li>
                <li class="active"><a href="#">配额列表</a></li>
            </ol>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <form class="form-inline well" id="product-query-form">
                        <span>方案名称:</span>
                        <input style="margin-right: 10px" type="text" class="input-medium" query-param="agreementNo"
                               name="agreementNo" placeholder="">

                    <#--<span>品牌名称:</span> <input type="text" class="input-medium" name="productName" placeholder="品牌名称">-->
                        <div style="float: right">
                            <button type="button" class="btn" id="btn-advanced-search" onclick="search()">
                                <i class="fa fa-search"></i>查询
                            </button>
                            <button type="button" class="btn" id="btn-advanced-add"
                                    onclick=gotoArticleByUrl('${ctx}/timesLimit/edit.html')>
                                <i class="fa fa-add"></i>新增
                            </button>
                        </div>
                    </form>
                    <div class="box">
                    <#--<div class="box-header">
                        <h3 class="box-title">协议管理</h3>
                    </div>-->
                        <!-- /.box-header -->
                        <div class="box-body">
                            <table id="agreementTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>序号</th>
                                    <th>方案名称</th>
                                    <th>时间窗口</th>
                                    <th>限制次数</th>
                                    <th>操作</th>
                                </tr>
                                </thead>
                                <tbody>
                                <#list timesLimits?if_exists as timesLimit>
                                <tr target="sid_proxy">
                                    <td class="center" style="width: 5%;">
                                        <div>${timesLimit_index+1}</div>
                                    </td>
                                    <td class="center">${timesLimit.name!}</td>
                                    <td class="center">
                                        <#if (timesLimit.timeUnit)==86400>日</#if>
                                        <#if (timesLimit.timeUnit)==604800>周</#if>
                                        <#if (timesLimit.timeUnit)==2592000>月</#if>
                                    </td>
                                    <td class="center">${timesLimit.limits!}</td>
                                    <td class="center">
                                        <a class="edit" rel="agreementEdit"
                                           href="${ctx}/timesLimit/edit.html?id=${timesLimit.id!}"><span
                                                class="doColorB">修改</span></a>
                                        <#--<a class="edit" rel="metaTemplateEdit" href="${ctx}/timesLimit/delete.html?id=${timesLimit.id!}">
                                            <span class="doColorB">删除</span></a>-->
                                    </td>
                                </tr>
                                </#list>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </section>
    </div>
    <!-- /.content-wrapper -->
<#include "../include/foot.ftl"/>
</div>
<!-- ./wrapper -->
<#include "../include/resource.ftl"/>

<script type="text/javascript">
    var table;

    $(function () {
        //  $('#permTable').DataTable();
        table = $('#agreementTable').DataTable({
//           "sPaginationType" : "full_numbers",//设置分页控件的模式
//            "bPaginate": true, //翻页功能
//            "bLengthChange": false, //改变每页显示数据数量
//            "bFilter": false, //过滤功能
//            "bSort": false, //排序功能
//            "bInfo": true,//页脚信息
//            "bAutoWidth": true,//自动宽度
//            "stateSave":true,//设置缓存页页码数据
            "oLanguage": {
                "sLengthMenu": "每页显示 _MENU_ 条记录",
                "sZeroRecords": "抱歉， 没有找到",
                "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
                "sInfoEmpty": "没有数据",
                "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
                "oPaginate": {
                    "sFirst": "首页",
                    "sPrevious": "前一页",
                    "sNext": "后一页",
                    "sLast": "尾页"
                },
                "sZeroRecords": "没有检索到数据",
                "sProcessing": "<img src='./loading.gif' />",
                "sSearch": "搜索"
            },

            "bStateSave": false,
            "bJQueryUI": true,
            "bPaginate": true,// 分页按钮
            "bFilter": false,// 搜索栏
            "bLengthChange": false,// 每行显示记录数
            "iDisplayLength": 1,// 每页显示行数
            "bSort": false,// 排序
            "bInfo": true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
            "bWidth": true,
            "bScrollCollapse": true,
            "sPaginationType": "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
            //  "bProcessing" : true,
            "bServerSide": true,
            "bDestroy": true,
            "bSortCellsTop": true,
            "sAjaxSource": "${ctx}/article/articleList",
            //  "sScrollY": "100%",
            "fnInitComplete": function () {
                this.fnAdjustColumnSizing(true);
            },
            "fnServerParams": function (aoData) {

                aoData.push({
                    "name": "title",
                    "value": $("#name-search").val()
                }, {
                    "name": "startDate",
                    "value": encodeURI($("#datepicker-start").val())
                }, {
                    "name": "endDate",
                    "value": encodeURI($("#datepicker-end").val())
                });
            },
            "aoColumns": [
                {
                    "data": function (row, type, set, meta) {
                        var c = meta.settings._iDisplayStart + meta.row + 1;
                        return c;
                    }
                },
                {"data": "title"},
                {
                    "data": function (row, type, set, meta) {
                        var publishDate = row.publishDate;
                        if (publishDate != undefined && publishDate != null && publishDate != "") {
                            publishDate = timeFormat(publishDate);
                        }
                        return publishDate;
                    }
                },
                {
                    "data": function (row, type, set, meta) {
                        var isDisable = row.param3;
                        if (isDisable == "1") {
                            isDisable = "是";
                        } else {
                            isDisable = "否";
                        }
                        return isDisable;
                    }
                },
                {
                    "data": function (row, type, set, meta) {
                        var organization = row.organization;
                        var organizationName = "";
                        if (organization != undefined && organization != null && organization != "") {
                            organizationName = organization.orgName;
                        }
                        return organizationName;
                    }
                }],

            "aoColumnDefs": [
                {
                    "sClass": "center",
                    "aTargets": [5],
                    "data": "id",
                    "mRender": function (a, b, c, d) {//id，c表示当前记录行对象
                        var flag = judgeDate(c.publishDate, new Date())
                        var strBuffer = "";
                        if (flag) {
                            strBuffer = '<a href=\"${ctx}/article/checkArticle?id=' + a + '\" >查看</a><span style=\"margin:0 10px\"></span><a href=\"${ctx}/article/editArticle?id=' + a + '\" >编辑</a><span style=\"margin:0 10px\"></span>' +
                                    '<a href=\"javascript:void(0);\" onclick=\"delRow(\'' + a + '\')\">删除</a>';
                        } else {
                            strBuffer = '<a href=\"${ctx}/article/checkArticle?id=' + a + '\" >查看</a><span style=\"margin:0 10px\"></span>' +
                                    '<a href=\"javascript:void(0);\" onclick=\"delRow(\'' + a + '\')\">删除</a>';
                        }
                        return strBuffer;
                    }
                }
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex) {//相当于对字段格式化

            },

            "fnServerData": function (sSource, aoData, fnCallback) {
                var serializeData = function (aoData) {
                    var data = {};
                    for (var i = 0; i < aoData.length; i++) {
                        var dd = aoData[i];
                        if (dd['value']) {
                            data[dd['name']] = dd['value'];
                        }
                    }
                    return $.param(data);
                };
                $.ajax({
                    "type": 'post',
                    "url": sSource,
                    //"dataType" : "json",
                    ///"dataSrc": "data",
                    "data": serializeData(aoData),
                    "success": function (resp) {
                        if (resp.noDataTip != undefined && resp.noDataTip != null && resp.noDataTip != "") {
                            window.wxc.xcConfirm(resp.noDataTip, "info", window.wxc.xcConfirm.btnEnum.ok);
                        }
                        fnCallback(resp);
                    }
                });
            }

        });

    });

    //查询
    function search() {
        var startDate = $("#datepicker-start").val().trim();
        var endDate = $("#datepicker-end").val().trim();
        var tipFlag = false;
        var tipText = "";
        if ($("#name-search").val().trim() == "" && startDate == "" && endDate == "") {
            tipText = "请选择您的查询条件！";
            tipFlag = true;
        } else {
            tipText = "您选择的日期不符，请检查后重新选择！";
            if (startDate != "" && endDate != "") {
                if (startDate > endDate) {
                    tipFlag = true;
                }
            } else if (startDate != "" && endDate == "") {
                tipFlag = true;
            } else if (startDate == "" && endDate != "") {
                tipFlag = true;
            }
        }
        if (tipFlag) {
            window.wxc.xcConfirm(tipText, "newCustom", window.wxc.xcConfirm.btnEnum.ok);
            return;
        }
        table.ajax.reload();
    }


    //根据url跳转至相应页面
    function gotoArticleByUrl(url) {
        window.location.href = url;
    }

    //删除文章
    function delRow(id) {
        var url = "${ctx}/channel-admin/channel/disable";
        var tipTxt = "温馨提示是否确定禁用？";
        var option = {
            onOk: function () {
                $.ajax({
                            url: url,
                            type: 'POST',
                            dataType: 'json',
                            data: {id: id},
                        })
                        .done(function (data) {
                            if (data.status == "success") {
                                window.wxc.xcConfirm(data.message, "success", window.wxc.xcConfirm.btnEnum.ok);
                                table.ajax.reload();
                            }
                        })
                        .fail(function () {
                            window.wxc.xcConfirm("异常，请联系管理员。", "error");
                            console.log("error");
                        });
            }
        }
        window.wxc.xcConfirm(tipTxt, "confirm", option);
    }
    //Date picker
    $('#datepicker-start').datepicker({
        format: 'yyyy-mm-dd',
        language: 'cn',
        autoclose: true
    });
    $('#datepicker-end').datepicker({
        format: 'yyyy-mm-dd',
        language: 'cn',
        autoclose: true
    });

    //格式化时间
    function timeFormat(timeStr) {
        var dateStr = new Date(timeStr);
        var year = dateStr.getFullYear();
        var month = (dateStr.getMonth() + 1) < 10 ? "0" + (dateStr.getMonth() + 1) : (dateStr.getMonth() + 1);
        var day = (dateStr.getDate()) < 10 ? "0" + (dateStr.getDate()) : (dateStr.getDate());
        var hour = (dateStr.getHours()) < 10 ? "0" + (dateStr.getHours()) : (dateStr.getHours());
        var minute = (dateStr.getMinutes()) < 10 ? "0" + (dateStr.getMinutes()) : (dateStr.getMinutes());
        var second = (dateStr.getSeconds()) < 10 ? "0" + (dateStr.getSeconds()) : (dateStr.getSeconds());
        timeStr = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
        return timeStr;
    }

    //判断两个日期的大小
    function judgeDate(date1, date2) {
        var oDate1 = new Date(date1);
        var oDate2 = new Date(date2);
        if (oDate1.getTime() >= oDate2.getTime()) {
            return true;
        } else {
            return false;
        }
    }


    function addDate(url) {
        window.location.href = url;
    }

    //查询
    function search() {

        table.ajax.reload();
    }

</script>
</body>
</html>
