/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.AbstractVariableEvaluationContextPostProcessor;
import org.springframework.security.web.access.expression.EvaluationContextPostProcessor;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.expression.WebExpressionConfigAttribute;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestVariablesExtractor;
import org.springframework.util.Assert;
import sinosoftgz.utils.Lang;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GatewayDbSecurityMetadataSource
extends DefaultFilterInvocationSecurityMetadataSource {
    private static final Log logger = LogFactory.getLog(GatewayDbSecurityMetadataSource.class);
    private FilterInvocationSecurityMetadataSource oldMetadataSource;
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private SecurityExpressionHandler<FilterInvocation> expressionHandler;
    static LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestToExpressionAttributesMap = Maps.newLinkedHashMap();
    private static final String sql = "select * from gateway_api_define  where enabled = true ";

    public void setOldMetadataSource(FilterInvocationSecurityMetadataSource oldMetadataSource) {
        this.oldMetadataSource = oldMetadataSource;
    }

    public GatewayDbSecurityMetadataSource(FilterInvocationSecurityMetadataSource oldMetadataSource, SecurityExpressionHandler<FilterInvocation> expressionHandler, DataSource dataSource) {
        super(GatewayDbSecurityMetadataSource.processMap((LinkedHashMap)Maps.newLinkedHashMap(), (ExpressionParser)expressionHandler.getExpressionParser()));
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.oldMetadataSource = oldMetadataSource;
        this.expressionHandler = expressionHandler;
        Assert.notNull(expressionHandler, (String)"A non-null SecurityExpressionHandler is required");
    }

    @PostConstruct
    public void reloadRequestMap() {
        List results = this.jdbcTemplate.queryForList("select * from gateway_api_define  where enabled = true ");
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        for (Map result : results) {
            if (Lang.isEmpty(result.get("path")) || Lang.isEmpty(result.get("enabled")) || Lang.isEmpty(result.get("role"))) continue;
            String pattern = result.get("path").toString();
            String role = result.get("role").toString();
            String roleWrapper = GatewayDbSecurityMetadataSource.hasRole((String)role);
            requestMap.put(new AntPathRequestMatcher(pattern), SecurityConfig.createList((String[])new String[]{roleWrapper}));
        }
        GatewayDbSecurityMetadataSource.processMap((LinkedHashMap)requestMap, (ExpressionParser)this.expressionHandler.getExpressionParser());
    }

    private static String hasRole(String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        if (role.startsWith("ROLE_")) {
            throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
        }
        return "hasRole('ROLE_" + role + "')";
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        Collection c2;
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        Collection c1 = super.getAllConfigAttributes();
        if (c1 != null) {
            allAttributes.addAll(c1);
        }
        if (this.oldMetadataSource != null && (c2 = this.oldMetadataSource.getAllConfigAttributes()) != null) {
            allAttributes.addAll(c2);
        }
        return allAttributes;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        Collection c2;
        Collection c1 = super.getAttributes(object);
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        if (c1 != null) {
            allAttributes.addAll(c1);
        }
        if (this.oldMetadataSource != null && (c2 = this.oldMetadataSource.getAttributes(object)) != null) {
            allAttributes.addAll(c2);
        }
        return allAttributes;
    }

    private static LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> processMap(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap, ExpressionParser parser) {
        LinkedHashMap tempRequestToExpressionAttributesMap = Maps.newLinkedHashMap();
        Assert.notNull((Object)parser, (String)"SecurityExpressionHandler returned a null parser object");
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : requestMap.entrySet()) {
            RequestMatcher request = entry.getKey();
            Assert.isTrue((entry.getValue().size() == 1 ? 1 : 0) != 0, (String)("Expected a single expression attribute for " + request));
            ArrayList<WebExpressionConfigAttribute> attributes = new ArrayList<WebExpressionConfigAttribute>(1);
            String expression = entry.getValue().toArray(new ConfigAttribute[1])[0].getAttribute();
            logger.debug((Object)("Adding web access control expression '" + expression + "', for " + request));
            AbstractVariableEvaluationContextPostProcessor postProcessor = GatewayDbSecurityMetadataSource.createPostProcessor((Object)request);
            try {
                attributes.add(new WebExpressionConfigAttribute(parser.parseExpression(expression), (EvaluationContextPostProcessor)postProcessor));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Failed to parse expression '" + expression + "'");
            }
            tempRequestToExpressionAttributesMap.put(request, attributes);
        }
        requestToExpressionAttributesMap.clear();
        requestToExpressionAttributesMap.putAll(tempRequestToExpressionAttributesMap);
        return requestToExpressionAttributesMap;
    }

    private static AbstractVariableEvaluationContextPostProcessor createPostProcessor(Object request) {
        if (request instanceof RequestVariablesExtractor) {
            return new ExpressionBasedFilterInvocationSecurityMetadataSource.RequestVariablesExtractorEvaluationContextPostProcessor((RequestVariablesExtractor)request);
        }
        return null;
    }
}

