/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.config;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import sinosoftgz.apiGateway.config.RedisConfig;
import sinosoftgz.apiGateway.service.DynamicRegisterRouteAndMetaSourceService;
import sinosoftgz.apiGateway.utils.RedisRateLimiter;
import sinosoftgz.apiGateway.utils.RedisTimesLimiter;
import sinosoftgz.apiGateway.zuul.RateLimitContext;

@Configuration
public class RedisConfig {
    @Value(value="classpath:ratelimiting.lua")
    private Resource luaScript;
    static final Logger logger = LoggerFactory.getLogger(RedisConfig.class);
    @Autowired
    DynamicRegisterRouteAndMetaSourceService dynamicRegisterRouteAndMetaSourceService;
    @Autowired
    ApplicationEventPublisher publisher;
    @Autowired
    RouteLocator routeLocator;
    @Autowired
    RateLimitContext rateLimitContext;

    @Bean
    public RedisScript<Long> luaCounterScript() {
        try {
            DefaultRedisScript redisScript = new DefaultRedisScript(IOUtils.toString((InputStream)this.luaScript.getInputStream(), (Charset)Charset.defaultCharset()), Boolean.TYPE);
            return redisScript;
        }
        catch (Exception e) {
            throw new RuntimeException("ratelimiting.lua not found");
        }
    }

    @Bean
    public RedisRateLimiter redisRateLimiter(StringRedisTemplate stringRedisTemplate) {
        RedisRateLimiter redisRateLimiter = new RedisRateLimiter(Long.valueOf(10000L), Long.valueOf(60L), true);
        redisRateLimiter.setRedisScript(this.luaCounterScript());
        redisRateLimiter.setRedisTemplate((RedisTemplate)stringRedisTemplate);
        return redisRateLimiter;
    }

    @Bean
    public RedisTimesLimiter redisTimesLimiter(StringRedisTemplate stringRedisTemplate) {
        RedisTimesLimiter redisTimesLimiter = new RedisTimesLimiter(Long.valueOf(10000000000L), Long.valueOf(86400L), false);
        redisTimesLimiter.setRedisScript(this.luaCounterScript());
        redisTimesLimiter.setRedisTemplate((RedisTemplate)stringRedisTemplate);
        return redisTimesLimiter;
    }

    @Bean
    RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        1 messageListener1 = new /* Unavailable Anonymous Inner Class!! */;
        ChannelTopic topic1 = new ChannelTopic("refreshRouteChannel");
        2 messageListener2 = new /* Unavailable Anonymous Inner Class!! */;
        ChannelTopic topic2 = new ChannelTopic("refreshMetaSourceChannel");
        3 messageListener3 = new /* Unavailable Anonymous Inner Class!! */;
        ChannelTopic topic3 = new ChannelTopic("publishRateLimitPlan");
        4 messageListener4 = new /* Unavailable Anonymous Inner Class!! */;
        ChannelTopic topic4 = new ChannelTopic("disableRateLimitPlan");
        5 messageListener5 = new /* Unavailable Anonymous Inner Class!! */;
        ChannelTopic topic5 = new ChannelTopic("refreshAllRateLimitPlan");
        container.addMessageListener((MessageListener)messageListener1, (Topic)topic1);
        container.addMessageListener((MessageListener)messageListener2, (Topic)topic2);
        container.addMessageListener((MessageListener)messageListener3, (Topic)topic3);
        container.addMessageListener((MessageListener)messageListener4, (Topic)topic4);
        container.addMessageListener((MessageListener)messageListener5, (Topic)topic5);
        return container;
    }
}

