/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.config;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.discovery.ServiceRouteMapper;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import sinosoftgz.apiGateway.filters.pre.RateLimitFilter;
import sinosoftgz.apiGateway.filters.pre.RequestParamWrapperFilter;
import sinosoftgz.apiGateway.filters.pre.SimpleFilter;
import sinosoftgz.apiGateway.zuul.DiscoveryDbClientRouteLocator;

@Configuration
public class ZuulConfig {
    @Autowired
    ApplicationEventPublisher publisher;
    @Autowired
    private DiscoveryClient discovery;
    @Autowired
    private ServiceRouteMapper serviceRouteMapper;
    @Autowired
    protected ZuulProperties zuulProperties;
    @Autowired
    protected ServerProperties server;
    @Autowired
    DataSource dataSource;

    public SimpleFilter simpleFilter() {
        return new SimpleFilter();
    }

    public RequestParamWrapperFilter requestParamWrapperFilter() {
        return new RequestParamWrapperFilter();
    }

    @Bean
    public RateLimitFilter rateLimitFilter() {
        return new RateLimitFilter();
    }

    @Bean
    public DiscoveryDbClientRouteLocator routeLocator() {
        DiscoveryDbClientRouteLocator discoveryDbClientRouteLocator = new DiscoveryDbClientRouteLocator(this.server.getServletPrefix(), this.discovery, this.zuulProperties, this.serviceRouteMapper);
        discoveryDbClientRouteLocator.setDataSource(this.dataSource);
        return discoveryDbClientRouteLocator;
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}

