/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import sinosoftgz.apiGateway.utils.RedisRateLimiter;
import sinosoftgz.apiGateway.utils.RedisTimesLimiter;
import sinosoftgz.apiGateway.zuul.DiscoveryDbClientRouteLocator;
import sinosoftgz.apiGateway.zuul.RateLimitContext;
import sinosoftgz.gateway.model.GatewayRateLimit;
import sinosoftgz.utils.Lang;

public class RateLimitFilter
extends ZuulFilter {
    private static Logger log = LoggerFactory.getLogger(RateLimitFilter.class);
    @Autowired
    DiscoveryDbClientRouteLocator discoveryDbClientRouteLocator;
    @Autowired
    RedisRateLimiter redisRateLimiter;
    @Autowired
    RedisTimesLimiter redisTimesLimiter;
    @Autowired
    RateLimitContext rateLimitContext;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 1;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        SecurityContext sc = SecurityContextHolder.getContext();
        Authentication authentication = sc.getAuthentication();
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Request oAuth2Request = ((OAuth2Authentication)authentication).getOAuth2Request();
            String clientId = oAuth2Request.getClientId();
            RequestContext ctx = RequestContext.getCurrentContext();
            HttpServletRequest request = ctx.getRequest();
            Route matchingRoute = this.discoveryDbClientRouteLocator.getMatchingRoute(request.getRequestURI());
            if (!Lang.isEmpty((Object)matchingRoute)) {
                GatewayRateLimit gatewayTimeLimit;
                String key = clientId + ":" + matchingRoute.getId();
                GatewayRateLimit gatewayRateLimit = (GatewayRateLimit)this.rateLimitContext.rateLimitMap.get(key);
                if (!Lang.isEmpty((Object)gatewayRateLimit)) {
                    String url = request.getRequestURI() + "?client_id=" + clientId;
                    boolean acquire = this.redisRateLimiter.acquire(url, gatewayRateLimit.getTimeUnit(), gatewayRateLimit.getLimits(), true);
                    log.info("\u63a5\u6536\u5230\u8bf7\u6c42\uff1a{},\u9650\u6d41\u662f\u5426\u901a\u8fc7\uff1a{}", (Object)request.getRequestURI(), (Object)acquire);
                    if (!acquire) {
                        throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u8fc7\u4e8e\u9891\u7e41!");
                    }
                }
                if (!Lang.isEmpty((Object)(gatewayTimeLimit = (GatewayRateLimit)this.rateLimitContext.timesLimitMap.get(key)))) {
                    String url = request.getRequestURI() + "?client_id=" + clientId;
                    boolean acquire = this.redisRateLimiter.acquire(url, gatewayTimeLimit.getTimeUnit(), gatewayTimeLimit.getLimits(), true);
                    log.info("\u63a5\u6536\u5230\u8bf7\u6c42\uff1a{},\u914d\u989d\u662f\u5426\u901a\u8fc7\uff1a{}", (Object)request.getRequestURI(), (Object)acquire);
                    if (!acquire) {
                        throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u6b21\u6570\u8d85\u51fa\u9650\u5236!");
                    }
                }
            }
        }
        return null;
    }
}

