/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import sinosoftgz.apiGateway.event.SecurityMetadataSourceRefreshedEvent;
import sinosoftgz.gateway.model.GatewayOauthClientDetails;

@Service
public class DynamicRegisterRouteAndMetaSourceService {
    @Autowired
    ApplicationEventPublisher publisher;
    @Autowired
    RouteLocator routeLocator;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ServerProperties serverProperties;

    public void refreshRouteAndMetaSource() {
        RoutesRefreshedEvent routesRefreshedEvent = new RoutesRefreshedEvent(this.routeLocator);
        this.publisher.publishEvent((ApplicationEvent)routesRefreshedEvent);
        this.publisher.publishEvent((ApplicationEvent)new SecurityMetadataSourceRefreshedEvent());
    }

    public void refreshTokenByClientId(String clientId) {
        GatewayOauthClientDetails clientDetails = (GatewayOauthClientDetails)this.jdbcTemplate.queryForObject("select * from oauth_client_details where client_id = ?", new Object[]{clientId}, (RowMapper)new BeanPropertyRowMapper(GatewayOauthClientDetails.class));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)clientDetails.getClientId());
        map.add((Object)"client_secret", (Object)clientDetails.getClientSecret());
        map.add((Object)"grant_type", (Object)clientDetails.getAuthorizedGrantTypes());
        map.add((Object)"scope", (Object)clientDetails.getScope());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/x-www-form-urlencoded");
        HttpEntity req = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity res = this.restTemplate.postForEntity("http://127.0.0.1:" + this.serverProperties.getPort() + "/oauth/token", (Object)req, String.class, new Object[0]);
        System.out.println((String)res.getBody());
    }
}

