/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.utils;

import java.util.Arrays;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.Assert;

public class RedisTimesLimiter {
    static final String prefix = "timesLimiter:";
    private String url;
    final Long timeUnit;
    final Long limit;
    private RedisScript<Long> redisScript;
    private RedisTemplate redisTemplate;
    private boolean isDurable = false;

    public void setRedisScript(RedisScript<Long> redisScript) {
        this.redisScript = redisScript;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public void setDurable(boolean durable) {
        this.isDurable = durable;
    }

    public RedisTimesLimiter(Long limit, Long timeUnit) {
        this.timeUnit = timeUnit;
        Assert.isTrue((timeUnit < 0x7FFFFFFFFFFFFFFEL ? 1 : 0) != 0, (String)"timeUnit out of range");
        this.limit = limit;
    }

    public RedisTimesLimiter(Long limit, Long timeUnit, boolean isDurable) {
        this(limit, timeUnit);
        this.isDurable = isDurable;
    }

    public boolean acquire() {
        return this.acquire(this.url);
    }

    public boolean acquire(String url) {
        StringBuffer key = new StringBuffer();
        key.append(prefix).append(url).append("&timestamp=").append(System.currentTimeMillis() / 1000L / this.timeUnit).append("&timeUnit=").append(this.timeUnit);
        Long expire = this.timeUnit + 1L;
        String convertExpire = this.isDurable ? "-1" : expire.toString();
        return this.redisTemplate.execute(this.redisScript, Arrays.asList(key.toString()), new Object[]{this.limit.toString(), convertExpire}).equals(1L);
    }

    public boolean acquire(String url, Long timeUnit, Long limit, boolean isDurable) {
        StringBuffer key = new StringBuffer();
        key.append(prefix).append(url).append("&timestamp=").append(System.currentTimeMillis() / 1000L / timeUnit).append("&timeUnit=").append(timeUnit);
        Long expire = timeUnit + 1L;
        String convertExpire = isDurable ? "-1" : expire.toString();
        return this.redisTemplate.execute(this.redisScript, Arrays.asList(key.toString()), new Object[]{limit.toString(), convertExpire}).equals(1L);
    }
}

