/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.service.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import sinosoftgz.member.model.common.Address;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.lang.Copys;

@Component
@Transactional(readOnly=true)
public class AddressService {
    public static void addressCpy(List<Address> fromList, List<Address> toList, String ... excludes) {
        if (toList == null) {
            toList = new ArrayList<Address>();
        }
        if (!Lang.isEmpty(fromList)) {
            for (Address from : fromList) {
                Address to = new Address();
                AddressService.addressCpy(from, to, excludes);
                toList.add(to);
            }
        }
    }

    public static void addressCpy(Address from, Address to, String ... excludes) {
        List<String> excludeFelids = excludes == null ? new ArrayList<String>() : Arrays.asList(excludes);
        Copys copys = Copys.create();
        copys.from((Object)from).excludes(new String[]{"parent", "child"}).to(new Object[]{to}).clear();
        if (!excludeFelids.contains("parent") && !Lang.isEmpty((Object)from.getParent())) {
            Address p = new Address();
            AddressService.addressCpy(from.getParent(), p, "child");
            to.setParent(p);
        }
        if (!excludeFelids.contains("child") && !Lang.isEmpty((Object)from.getChild())) {
            ArrayList<Address> cl = new ArrayList<Address>();
            for (Address a : from.getChild()) {
                Address c = new Address();
                AddressService.addressCpy(a, c, "parent", "child");
                cl.add(c);
            }
            to.setChild(cl);
        }
    }
}

