/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.service.service;

import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import sinosoftgz.member.api.vo.MemberVo;
import sinosoftgz.member.model.core.CoreCompany;
import sinosoftgz.member.model.core.CoreUser;
import sinosoftgz.member.model.core.CoreUserExt;
import sinosoftgz.member.model.repository.core.CompanyRepos;
import sinosoftgz.member.model.repository.core.UserRepos;
import sinosoftgz.member.model.repository.member.MemberRepos;
import sinosoftgz.member.model.shop.Member;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.data.Encodes;
import sinosoftgz.utils.lang.Copys;
import sinosoftgz.utils.security.Digests;

@Transactional
@Component
public class UserService {
    @Autowired
    private UserRepos userRepos;
    @Autowired
    private MemberRepos memberRepos;
    @Autowired
    private CompanyRepos companyRepos;
    public static final int HASH_INTERATIONS = 1024;
    private static final String passWorldSalt = "12345678abcdefgh";
    public static final int SALT_SIZE = 8;

    public static String getPassWorldSalt() {
        return passWorldSalt;
    }

    public String entryptPassword(String password, String salt) {
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes(), (byte[])salt.getBytes(), (int)1024);
        return Encodes.encodeHex((byte[])hashPassword);
    }

    public CoreUser findById(String id) {
        return (CoreUser)this.userRepos.findOne((Serializable)((Object)id));
    }

    public CoreUser findByUserName(String username) {
        return this.userRepos.findByUsername(username);
    }

    public CoreUser findByPhoneOrEmail(String userLoginId) {
        return this.userRepos.findByPhoneOrEmail(userLoginId);
    }

    public CoreUser saveBean(CoreUser coreUser) {
        return (CoreUser)this.userRepos.save((Object)coreUser);
    }

    public Page<CoreUser> findPageByParams(String username, Pageable pageable) {
        CoreUser coreUser = new CoreUser();
        coreUser.setIsDelete(Boolean.valueOf(false));
        coreUser.setUserType("member");
        coreUser.setUsername(username);
        coreUser.setDisabled(null);
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues().withMatcher("username", ExampleMatcher.GenericPropertyMatcher.of((ExampleMatcher.StringMatcher)ExampleMatcher.StringMatcher.CONTAINING, (boolean)true));
        Example example = Example.of((Object)coreUser, (ExampleMatcher)matcher);
        return this.userRepos.findAll(example, pageable);
    }

    public Page<CoreUser> findPageByParams(String username, String coreCompanyId, Pageable pageable) {
        CoreUser coreUser = new CoreUser();
        coreUser.setIsDelete(Boolean.valueOf(false));
        coreUser.setUserType("member");
        coreUser.setUsername(username);
        coreUser.setDisabled(null);
        CoreCompany coreCompany = (CoreCompany)this.companyRepos.findOne((Serializable)((Object)coreCompanyId));
        coreUser.setCoreCompany(coreCompany);
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues().withMatcher("username", ExampleMatcher.GenericPropertyMatcher.of((ExampleMatcher.StringMatcher)ExampleMatcher.StringMatcher.CONTAINING, (boolean)true)).withMatcher("coreCompany", ExampleMatcher.GenericPropertyMatcher.of((ExampleMatcher.StringMatcher)ExampleMatcher.StringMatcher.CONTAINING, (boolean)true));
        Example example = Example.of((Object)coreUser, (ExampleMatcher)matcher);
        return this.userRepos.findAll(example, pageable);
    }

    public MemberVo findUserByUserNameAndPassword(String userName, String password) {
        password = this.entryptPassword(password, passWorldSalt);
        CoreUser coreUser = this.userRepos.findByUsernameAndPasswordAndIsDelete(userName, password, false);
        return this.loadMemberVo(coreUser);
    }

    public MemberVo loadMemberVo(CoreUser coreUser) {
        if (coreUser == null) {
            return null;
        }
        Member member = this.memberRepos.findByCoreUser(coreUser);
        MemberVo memberVo = new MemberVo();
        Member member1 = new Member();
        CoreUser coreUser1 = new CoreUser();
        CoreCompany coreCompany = new CoreCompany();
        CoreUserExt coreUserExt = new CoreUserExt();
        Copys copys = Copys.create();
        copys.from((Object)coreUser).excludes(new String[]{"coreCompany", "coreUserExt"}).to(new Object[]{coreUser1}).clear();
        copys.from((Object)coreUser.getCoreCompany()).excludes(new String[]{"parent", "child"}).to(new Object[]{coreCompany}).clear();
        copys.from((Object)coreUser.getCoreUserExt()).excludes(new String[]{"coreUser"}).to(new Object[]{coreUserExt}).clear();
        copys.from((Object)member).excludes(new String[]{"addresses", "contactses", "creditses", "coupons", "moneys", "viewHises", "favorites", "roles"}).to(new Object[]{member1}).clear();
        coreUser1.setCoreCompany(coreCompany);
        coreUser1.setCoreUserExt(coreUserExt);
        memberVo.setMember(member1);
        memberVo.setUser(coreUser1);
        return memberVo;
    }

    public List<CoreUser> findByUsernameAndPhoneAndEmail(String username, String phone, String email) {
        if (Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email)) {
            return this.userRepos.findByIsDeleteOrderByLastUpdatedDesc(false);
        }
        if (!Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email)) {
            username = "%" + username + "%";
            return this.userRepos.findByUsernameLikeAndIsDeleteOrderByLastUpdatedDesc(username, false);
        }
        if (Lang.isEmpty((Object)username) && !Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email)) {
            phone = "%" + phone + "%";
            return this.userRepos.findByPhoneLikeAndIsDeleteOrderByLastUpdatedDesc(phone, false);
        }
        if (Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && !Lang.isEmpty((Object)email)) {
            email = "%" + email + "%";
            return this.userRepos.findByEmailLikeAndIsDeleteOrderByLastUpdatedDesc(email, false);
        }
        if (!Lang.isEmpty((Object)username) && !Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email)) {
            username = "%" + username + "%";
            phone = "%" + phone + "%";
            return this.userRepos.findByUsernameLikeAndPhoneLikeAndIsDeleteOrderByLastUpdatedDesc(username, phone, false);
        }
        if (!Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && !Lang.isEmpty((Object)email)) {
            username = "%" + username + "%";
            email = "%" + email + "%";
            return this.userRepos.findByUsernameLikeAndEmailLikeAndIsDeleteOrderByLastUpdatedDesc(username, email, false);
        }
        if (Lang.isEmpty((Object)username) && !Lang.isEmpty((Object)phone) && !Lang.isEmpty((Object)email)) {
            phone = "%" + phone + "%";
            email = "%" + email + "%";
            return this.userRepos.findByPhoneLikeAndEmailLikeAndIsDeleteOrderByLastUpdatedDesc(phone, email, false);
        }
        if (!(Lang.isEmpty((Object)username) || Lang.isEmpty((Object)phone) || Lang.isEmpty((Object)email))) {
            username = "%" + username + "%";
            phone = "%" + phone + "%";
            email = "%" + email + "%";
            return this.userRepos.findByUsernameLikeAndPhoneLikeAndEmailLikeAndIsDeleteOrderByLastUpdatedDesc(username, phone, email, false);
        }
        return this.userRepos.findByIsDeleteOrderByLastUpdatedDesc(false);
    }

    public CoreUser saveCoreUser(CoreUser coreUser) {
        return (CoreUser)this.userRepos.save((Object)coreUser);
    }

    public CoreUser findByPhone(String phone) {
        return this.userRepos.findByPhoneAndIsDelete(phone, false);
    }

    public CoreUser findByEmail(String email) {
        return this.userRepos.findByEmailAndIsDelete(email, false);
    }

    public Member findByCoreUser(CoreUser coreUser) {
        return this.memberRepos.findByCoreUser(coreUser);
    }

    public CoreUser updateCoreUser(CoreUser coreUser) {
        return (CoreUser)this.userRepos.save((Object)coreUser);
    }

    public Member updateMember(Member member) {
        return (Member)this.memberRepos.save((Object)member);
    }

    public String encryptPasswd(String orginPasswd) {
        return this.entryptPassword(orginPasswd, passWorldSalt);
    }

    public CoreUser isExistCore(String username, String phone, String email) {
        CoreUser coreUser = null;
        if (!Lang.isEmpty((Object)username) ? !Lang.isEmpty((Object)(coreUser = this.userRepos.findByUsernameAndIsDelete(username, false))) : (!Lang.isEmpty((Object)phone) ? !Lang.isEmpty((Object)(coreUser = this.userRepos.findByPhoneAndIsDelete(phone, false))) : !Lang.isEmpty((Object)email) && !Lang.isEmpty((Object)(coreUser = this.userRepos.findByEmailAndIsDelete(email, false))))) {
            return coreUser;
        }
        return coreUser;
    }

    public void deleteCoreUserById(String id) {
        Member member;
        CoreUser user;
        if (!(Lang.isEmpty((Object)id) || Lang.isEmpty((Object)(user = (CoreUser)this.userRepos.findOne((Serializable)((Object)id)))) || Lang.isEmpty((Object)(member = this.memberRepos.findByCoreUser(user))))) {
            member.setScore(Integer.valueOf(0));
            this.memberRepos.save((Object)member);
            user.setIsDelete(Boolean.valueOf(true));
            user.setUsername(user.getUsername() + user.getId());
            user.setPhone(user.getPhone() + user.getId());
            user.setEmail(user.getEmail() + user.getId());
            this.userRepos.save((Object)user);
        }
    }

    public List<CoreUser> findCoreuserByUsername(String username) {
        return this.userRepos.findByIsDeleteAndUsername(false, username);
    }
}

