/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.api;

import java.util.List;
import java.util.Map;
import sinosoftgz.member.api.vo.AddressVo;
import sinosoftgz.member.model.common.Address;
import sinosoftgz.member.model.common.IpAddress;

public interface AddressCommonApi {
    public IpAddress findByIp(Long var1);

    public Address findAreaByIp(Long var1, int var2);

    public Address findById(String var1);

    public AddressVo findVoById(String var1);

    public List<Address> addressList(AddressLevel var1, String var2, Boolean var3);

    public List<Address> addressList(AddressLevel var1, Boolean var2);

    public List<AddressVo> addressVoList(AddressLevel var1, String var2, Boolean var3);

    public Address findFirstChild(String var1, Boolean var2);

    public List<Address> findByFirstChar(String var1, AddressLevel var2, Boolean var3);

    public List<Address> findByPingYin(String var1, AddressLevel var2, Boolean var3);

    public List<Address> findByJianPing(String var1, AddressLevel var2, Boolean var3);

    public List<Address> findByCoordinates(String var1, Float var2, Float var3, Float var4, Float var5, Boolean var6);

    public Map<Integer, String> areaCodeNodeList(String var1);

    public Map<Integer, Address> areaNodeList(String var1);

    public Long childrenCounts(String var1);

    public Long childrenCounts(Address var1);

    public Address findByCityCode(String var1);

    public static enum AddressLevel {
        COUNTRY(0),
        PROVINCE(1),
        CITY(2),
        AREA(3),
        TOWN(4);

        private final Integer value;

        private AddressLevel(Integer value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AddressLevel getLevel(int levelCode) {
            for (AddressLevel c : AddressLevel.values()) {
                if (c.value != levelCode) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.getValue());
        }
    }
}

