/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table(indexes={@Index(name="idx_coupon_store", columnList="store_id")})
public class Coupon
extends BaseDomain
implements Serializable {
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36)
    protected String id;
    private String code;
    private String couponName;
    private String type;
    private Date couponTime;
    private Date couponEndTime;
    @Column(scale=2)
    private BigDecimal couponPrice;
    @Column(scale=2)
    private BigDecimal leastPrice;
    private String couponPicture;
    @Column(length=36, name="category_id")
    private String categoryId;
    @Column(length=36, name="store_id")
    private String storeId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coupon coupon = (Coupon)o;
        return !(this.id == null ? coupon.id != null : !this.id.equals(coupon.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCouponName() {
        return this.couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getCouponTime() {
        return this.couponTime;
    }

    public void setCouponTime(Date couponTime) {
        this.couponTime = couponTime;
    }

    public Date getCouponEndTime() {
        return this.couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public BigDecimal getCouponPrice() {
        return this.couponPrice;
    }

    public void setCouponPrice(BigDecimal couponPrice) {
        this.couponPrice = couponPrice;
    }

    public BigDecimal getLeastPrice() {
        return this.leastPrice;
    }

    public void setLeastPrice(BigDecimal leastPrice) {
        this.leastPrice = leastPrice;
    }

    public String getCouponPicture() {
        return this.couponPicture;
    }

    public void setCouponPicture(String couponPicture) {
        this.couponPicture = couponPicture;
    }
}

