/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.core;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.core.CoreCompany;
import sinosoftgz.member.model.core.CoreUserExt;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="uk_user_username", columnNames={"username"}), @UniqueConstraint(name="uk_user_phone", columnNames={"phone"}), @UniqueConstraint(name="uk_user_email", columnNames={"email"})}, indexes={@Index(name="idx_user_username", columnList="username", unique=true), @Index(name="idx_user_phone", columnList="phone", unique=true), @Index(name="idx_user_email", columnList="email", unique=true), @Index(name="idx_user_company", columnList="company_id")})
public class CoreUser
extends BaseDomain
implements Serializable {
    public static String USER_TYPE_BUYER = "buyer";
    public static String USER_TYPE_MEMBER = "member";
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36, updatable=false)
    protected String id;
    @Column(length=100, name="username")
    private String username;
    @Transient
    private String old_username;
    @Column(name="current_login_time")
    private String currentLoginTime;
    @Column(name="err_count")
    @ColumnDefault(value="0")
    private Long errCount = 0L;
    @Column(name="is_disabled")
    @ColumnDefault(value="0")
    private Boolean disabled = false;
    private String mergeUserIds;
    private Boolean merged;
    @Column(name="login_count")
    @ColumnDefault(value="0")
    private Long loginCount = 0L;
    @Column(length=20, name="phone")
    private String phone;
    @Transient
    private String old_phone;
    @Column(length=50, name="email")
    private String email;
    @Transient
    private String old_email;
    @Column(length=128)
    private String password;
    @Transient
    private String old_password;
    @Column(length=50, name="id_card")
    private String idCard;
    @Column(length=10)
    private String source;
    @Column(length=16)
    private String salt;
    @Column(length=10)
    private String userType;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="company_id", foreignKey=@ForeignKey(name="fk_user_company"))
    private CoreCompany coreCompany;
    @OneToOne(mappedBy="coreUser")
    private CoreUserExt coreUserExt;

    public String getMergeUserIds() {
        if (this.mergeUserIds == null || "".equals(this.mergeUserIds.trim())) {
            return this.id;
        }
        return this.mergeUserIds;
    }

    public void setMergeUserIds(String mergeUserIds) {
        this.mergeUserIds = mergeUserIds;
    }

    public Boolean getMerged() {
        return this.merged;
    }

    public void setMerged(Boolean merged) {
        this.merged = merged;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getOld_username() {
        return this.old_username;
    }

    public void setOld_username(String old_username) {
        this.old_username = old_username;
    }

    public String getOld_phone() {
        return this.old_phone;
    }

    public void setOld_phone(String old_phone) {
        this.old_phone = old_phone;
    }

    public String getOld_email() {
        return this.old_email;
    }

    public void setOld_email(String old_email) {
        this.old_email = old_email;
    }

    public String getOld_password() {
        return this.old_password;
    }

    public void setOld_password(String old_password) {
        this.old_password = old_password;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public CoreCompany getCoreCompany() {
        return this.coreCompany;
    }

    public void setCoreCompany(CoreCompany coreCompany) {
        this.coreCompany = coreCompany;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CoreUserExt getCoreUserExt() {
        return this.coreUserExt;
    }

    public void setCoreUserExt(CoreUserExt coreUserExt) {
        this.coreUserExt = coreUserExt;
    }

    public String getCurrentLoginTime() {
        return this.currentLoginTime;
    }

    public void setCurrentLoginTime(String currentLoginTime) {
        this.currentLoginTime = currentLoginTime;
    }

    public Long getErrCount() {
        return this.errCount;
    }

    public void setErrCount(Long errCount) {
        this.errCount = errCount;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Long getLoginCount() {
        return this.loginCount;
    }

    public void setLoginCount(Long loginCount) {
        this.loginCount = loginCount;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreUser coreUser = (CoreUser)o;
        return !(this.id == null ? coreUser.id != null : !this.id.equals(coreUser.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

