/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.org;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.org.OrganizationCredits;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table(name="organization")
public class Organization
extends BaseDomain
implements Serializable {
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(updatable=false, length=36)
    protected String id;
    @Column(name="org_name")
    private String orgName;
    @Column(name="org_code", unique=true)
    private String orgCode;
    @Column(name="org_properties")
    private String orgProperties;
    @Column(name="org_scale")
    private String orgScale;
    @Column(name="org_type")
    private String orgType;
    @Column(name="org_number")
    private String orgNumber;
    @Column(name="tax_reg_number")
    private String taxRegNumber;
    @Column(name="business_license")
    private String businessLicense;
    @Column(name="org_score")
    private Integer orgScore;
    private BigDecimal depositMoney;
    private BigDecimal currentMoney;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="organization", cascade={CascadeType.ALL})
    private List<OrganizationCredits> orgCreditses = new ArrayList<OrganizationCredits>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization that = (Organization)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Organization(String orgName, String orgCode, String orgProperties, String orgScale, String orgType, String orgNumber, String taxRegNumber, String businessLicense, Integer orgScore, BigDecimal depositMoney, BigDecimal currentMoney, List<OrganizationCredits> orgCreditses) {
        this.orgName = orgName;
        this.orgCode = orgCode;
        this.orgProperties = orgProperties;
        this.orgScale = orgScale;
        this.orgType = orgType;
        this.orgNumber = orgNumber;
        this.taxRegNumber = taxRegNumber;
        this.businessLicense = businessLicense;
        this.orgScore = orgScore;
        this.depositMoney = depositMoney;
        this.currentMoney = currentMoney;
        this.orgCreditses = orgCreditses;
    }

    public Organization() {
    }

    public BigDecimal getDepositMoney() {
        return this.depositMoney;
    }

    public void setDepositMoney(BigDecimal depositMoney) {
        this.depositMoney = depositMoney;
    }

    public BigDecimal getCurrentMoney() {
        return this.currentMoney;
    }

    public void setCurrentMoney(BigDecimal currentMoney) {
        this.currentMoney = currentMoney;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgProperties() {
        return this.orgProperties;
    }

    public void setOrgProperties(String orgProperties) {
        this.orgProperties = orgProperties;
    }

    public String getOrgScale() {
        return this.orgScale;
    }

    public void setOrgScale(String orgScale) {
        this.orgScale = orgScale;
    }

    public String getOrgType() {
        return this.orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public String getTaxRegNumber() {
        return this.taxRegNumber;
    }

    public void setTaxRegNumber(String taxRegNumber) {
        this.taxRegNumber = taxRegNumber;
    }

    public String getBusinessLicense() {
        return this.businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public Integer getOrgScore() {
        return this.orgScore;
    }

    public void setOrgScore(Integer orgScore) {
        this.orgScore = orgScore;
    }

    public List<OrganizationCredits> getOrgCreditses() {
        return this.orgCreditses;
    }

    public void setOrgCreditses(List<OrganizationCredits> orgCreditses) {
        this.orgCreditses = orgCreditses;
    }

    public String toString() {
        return "Organization{id='" + this.id + '\'' + ", orgName='" + this.orgName + '\'' + ", orgCode='" + this.orgCode + '\'' + ", orgProperties='" + this.orgProperties + '\'' + ", orgScale='" + this.orgScale + '\'' + ", orgType='" + this.orgType + '\'' + ", orgNumber='" + this.orgNumber + '\'' + ", taxRegNumber='" + this.taxRegNumber + '\'' + ", businessLicense='" + this.businessLicense + '\'' + ", orgScore=" + this.orgScore + ", depositMoney=" + this.depositMoney + ", currentMoney=" + this.currentMoney + ", orgCreditses=" + this.orgCreditses + '}';
    }
}

