/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.shop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.core.CoreUser;
import sinosoftgz.member.model.shop.MemberAddress;
import sinosoftgz.member.model.shop.MemberContacts;
import sinosoftgz.member.model.shop.MemberCoupon;
import sinosoftgz.member.model.shop.MemberCredits;
import sinosoftgz.member.model.shop.MemberFavorite;
import sinosoftgz.member.model.shop.MemberGroup;
import sinosoftgz.member.model.shop.MemberMoney;
import sinosoftgz.member.model.shop.MemberRole;
import sinosoftgz.member.model.shop.MemberViewHis;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table(indexes={@Index(name="idx_member_user_id", columnList="user_id")})
public class Member
extends BaseDomain
implements Serializable {
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36, updatable=false)
    protected String id;
    @Column(name="organization_id", nullable=false)
    private String organizationId;
    @Column(name="is_first_login")
    @ColumnDefault(value="0")
    private Integer isFirstLogin;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, updatable=false, name="user_id", foreignKey=@ForeignKey(name="fk_member_user"))
    private CoreUser coreUser;
    @Column(length=100)
    private String realName;
    private Boolean gender;
    private Integer score;
    private Integer freezeScore;
    private BigDecimal money;
    private Date birthday;
    private Boolean marriage;
    @Column(length=50)
    private String company;
    private Boolean isCar;
    private String position;
    private String address;
    private String schoolTag;
    private Date schoolTagDate;
    private String favoriteBrand;
    private String favoriteStar;
    private String favoriteMovie;
    private String favoritePersonage;
    private Boolean isEmployee;
    private String personId;
    private Boolean isAdmin;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="group_id", foreignKey=@ForeignKey(name="fk_member_group", foreignKeyDefinition="group_id"))
    private MemberGroup memberGroup;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberAddress> addresses = new ArrayList<MemberAddress>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberContacts> contactses = new ArrayList<MemberContacts>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberCredits> creditses = new ArrayList<MemberCredits>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberCoupon> coupons = new ArrayList<MemberCoupon>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberMoney> moneys = new ArrayList<MemberMoney>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberViewHis> viewHises = new ArrayList<MemberViewHis>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="member", cascade={CascadeType.ALL})
    private List<MemberFavorite> favorites = new ArrayList<MemberFavorite>();
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinTable(name="member_role_links", inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="id")}, joinColumns={@JoinColumn(name="member_id", referencedColumnName="id")}, foreignKey=@ForeignKey(name="fk_mr_links_role_member"), inverseForeignKey=@ForeignKey(name="fk_mr_links_member_role"))
    private List<MemberRole> roles = new ArrayList<MemberRole>();

    public List<MemberAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<MemberAddress> addresses) {
        this.addresses = addresses;
    }

    public List<MemberContacts> getContactses() {
        return this.contactses;
    }

    public void setContactses(List<MemberContacts> contactses) {
        this.contactses = contactses;
    }

    public List<MemberCredits> getCreditses() {
        return this.creditses;
    }

    public void setCreditses(List<MemberCredits> creditses) {
        this.creditses = creditses;
    }

    public List<MemberCoupon> getCoupons() {
        return this.coupons;
    }

    public void setCoupons(List<MemberCoupon> coupons) {
        this.coupons = coupons;
    }

    public List<MemberMoney> getMoneys() {
        return this.moneys;
    }

    public void setMoneys(List<MemberMoney> moneys) {
        this.moneys = moneys;
    }

    public List<MemberViewHis> getViewHises() {
        return this.viewHises;
    }

    public void setViewHises(List<MemberViewHis> viewHises) {
        this.viewHises = viewHises;
    }

    public List<MemberFavorite> getFavorites() {
        return this.favorites;
    }

    public void setFavorites(List<MemberFavorite> favorites) {
        this.favorites = favorites;
    }

    public List<MemberRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<MemberRole> roles) {
        this.roles = roles;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getId() {
        return this.id;
    }

    public CoreUser getCoreUser() {
        return this.coreUser;
    }

    public void setCoreUser(CoreUser coreUser) {
        this.coreUser = coreUser;
    }

    public MemberGroup getMemberGroup() {
        return this.memberGroup;
    }

    public void setMemberGroup(MemberGroup memberGroup) {
        this.memberGroup = memberGroup;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public Boolean getGender() {
        return this.gender;
    }

    public void setGender(Boolean gender) {
        this.gender = gender;
    }

    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Integer getFreezeScore() {
        return this.freezeScore;
    }

    public void setFreezeScore(Integer freezeScore) {
        this.freezeScore = freezeScore;
    }

    public BigDecimal getMoney() {
        return this.money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public Boolean getMarriage() {
        return this.marriage;
    }

    public void setMarriage(Boolean marriage) {
        this.marriage = marriage;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Boolean getIsCar() {
        return this.isCar;
    }

    public void setIsCar(Boolean isCar) {
        this.isCar = isCar;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSchoolTag() {
        return this.schoolTag;
    }

    public void setSchoolTag(String schoolTag) {
        this.schoolTag = schoolTag;
    }

    public Date getSchoolTagDate() {
        return this.schoolTagDate;
    }

    public void setSchoolTagDate(Date schoolTagDate) {
        this.schoolTagDate = schoolTagDate;
    }

    public String getFavoriteBrand() {
        return this.favoriteBrand;
    }

    public void setFavoriteBrand(String favoriteBrand) {
        this.favoriteBrand = favoriteBrand;
    }

    public String getFavoriteStar() {
        return this.favoriteStar;
    }

    public void setFavoriteStar(String favoriteStar) {
        this.favoriteStar = favoriteStar;
    }

    public String getFavoriteMovie() {
        return this.favoriteMovie;
    }

    public void setFavoriteMovie(String favoriteMovie) {
        this.favoriteMovie = favoriteMovie;
    }

    public String getFavoritePersonage() {
        return this.favoritePersonage;
    }

    public void setFavoritePersonage(String favoritePersonage) {
        this.favoritePersonage = favoritePersonage;
    }

    public Boolean getIsEmployee() {
        return this.isEmployee;
    }

    public void setIsEmployee(Boolean isEmployee) {
        this.isEmployee = isEmployee;
    }

    public Integer getIsFirstLogin() {
        return this.isFirstLogin;
    }

    public void setIsFirstLogin(Integer isFirstLogin) {
        this.isFirstLogin = isFirstLogin;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Boolean getAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return !(this.id == null ? member.id != null : !this.id.equals(member.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

