/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.shop;

import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.shop.Member;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table
public class MemberAddress
extends BaseDomain
implements Serializable {
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36, updatable=false)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="member_id", foreignKey=@ForeignKey(name="fk_m_address_m_id"))
    private Member member;
    private String username;
    private Boolean gender;
    private String detailaddress;
    private String postCode;
    private String tel;
    @Column(length=36)
    private String areaCode;
    @Column(length=50)
    private String areaName;
    private String phone;
    private String extNumber;
    private Boolean isDefault;
    @Column(length=20)
    private String type;
    @Column(length=36, name="user_id", nullable=false, updatable=false)
    private String userId;
    @Column(length=36)
    private String provinceCode;
    @Column(length=50)
    private String provinceName;
    @Column(length=36)
    private String cityCode;
    @Column(length=50)
    private String cityName;
    @Column(length=36)
    private String countryCode;
    @Column(length=50)
    private String countryName;
    @Column(length=36)
    private String townCode;
    @Column(length=50)
    private String townName;
    private String addressDetail;

    public String getUserId() {
        if (this.userId != null && !"".equals(this.userId.trim())) {
            return this.userId;
        }
        return this.member.getCoreUser().getId();
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getMinumAreaCode() {
        if (!Lang.isEmpty((Object)this.townCode)) {
            return this.townCode;
        }
        if (!Lang.isEmpty((Object)this.areaCode)) {
            return this.areaCode;
        }
        if (!Lang.isEmpty((Object)this.cityCode)) {
            return this.cityCode;
        }
        if (!Lang.isEmpty((Object)this.provinceCode)) {
            return this.provinceCode;
        }
        return null;
    }

    public String[] getAreaCodeList() {
        ArrayList<String> arr = new ArrayList<String>();
        if (!Lang.isEmpty((Object)this.provinceCode)) {
            arr.add(this.provinceCode);
            if (!Lang.isEmpty((Object)this.cityCode)) {
                arr.add(this.cityCode);
                if (!Lang.isEmpty((Object)this.areaCode)) {
                    arr.add(this.areaCode);
                    if (!Lang.isEmpty((Object)this.townCode)) {
                        arr.add(this.townCode);
                    }
                }
            }
        }
        return arr.toArray(new String[arr.size()]);
    }

    public Boolean getDefault() {
        return this.isDefault;
    }

    public void setDefault(Boolean aDefault) {
        this.isDefault = aDefault;
    }

    public String getTownCode() {
        return this.townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }

    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Boolean getGender() {
        return this.gender;
    }

    public void setGender(Boolean gender) {
        this.gender = gender;
    }

    public String getDetailaddress() {
        return this.detailaddress;
    }

    public void setDetailaddress(String detailaddress) {
        this.detailaddress = detailaddress;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExtNumber() {
        return this.extNumber;
    }

    public void setExtNumber(String extNumber) {
        this.extNumber = extNumber;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getAddressDetail() {
        return this.addressDetail;
    }

    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getDisplayAddress() {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.isEmpty((Object)this.getCountryName()) ? "" : this.getCountryName()).append(Lang.isEmpty((Object)this.getProvinceName()) ? "" : this.getProvinceName());
        if (!(Lang.isEmpty((Object)this.getCityName()) || "\u5317\u4eac".equals(this.getProvinceName()) || "\u5929\u6d25".equals(this.getProvinceName()) || "\u4e0a\u6d77".equals(this.getProvinceName()) || "\u91cd\u5e86".equals(this.getProvinceName()))) {
            sb.append(Lang.isEmpty((Object)this.getCityName()) ? "" : this.getCityName());
        }
        sb.append(Lang.isEmpty((Object)this.getAreaName()) ? "" : this.getAreaName()).append(Lang.isEmpty((Object)this.getTownName()) ? "" : this.getTownName()).append(Lang.isEmpty((Object)this.getAddressDetail()) ? "" : this.getAddressDetail());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberAddress that = (MemberAddress)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "MemberAddress{id='" + this.id + '\'' + ", member=" + this.member + ", username='" + this.username + '\'' + ", gender=" + this.gender + ", detailaddress='" + this.detailaddress + '\'' + ", postCode='" + this.postCode + '\'' + ", tel='" + this.tel + '\'' + ", areaCode='" + this.areaCode + '\'' + ", areaName='" + this.areaName + '\'' + ", phone='" + this.phone + '\'' + ", extNumber='" + this.extNumber + '\'' + ", isDefault=" + this.isDefault + ", type='" + this.type + '\'' + ", provinceCode='" + this.provinceCode + '\'' + ", provinceName='" + this.provinceName + '\'' + ", cityCode='" + this.cityCode + '\'' + ", cityName='" + this.cityName + '\'' + ", countryCode='" + this.countryCode + '\'' + ", countryName='" + this.countryName + '\'' + ", addressDetail='" + this.addressDetail + '\'' + '}';
    }
}

