/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.shop;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.shop.Member;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="uk_favorite_tar", columnNames={"member_id", "type", "target_id"})})
public class MemberFavorite
extends BaseDomain
implements Serializable {
    public static final String FAVORITE_TYPE_CART_ITEM = "CART_ITEM";
    public static final String FAVORITE_TYPE_PRODUCT_ID = "PRODUCT_ID";
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36, updatable=false)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="member_id", foreignKey=@ForeignKey(name="fk_m_address_member"))
    private Member member;
    @Column(length=10)
    private String type;
    @Column(length=36, name="target_id")
    private String targetId;
    @Column(length=36, name="user_id", nullable=false, updatable=false)
    private String userId;

    public String getUserId() {
        if (this.userId != null && !"".equals(this.userId.trim())) {
            return this.userId;
        }
        return this.member.getCoreUser().getId();
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberFavorite that = (MemberFavorite)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String toString() {
        return "MemberFavorite{id='" + this.id + '\'' + ", member=" + this.member + ", type='" + this.type + '\'' + ", targetId='" + this.targetId + '\'' + '}';
    }
}

