/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.shop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.shop.Member;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table
public class MemberOrder
extends BaseDomain
implements Serializable {
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36, updatable=false)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="member_id", foreignKey=@ForeignKey(name="fk_m_order_m_id"))
    private Member member;
    @Column(length=20)
    private String riskCode;
    @Column(length=100)
    private String productName;
    @Column(length=100)
    private String policyNo;
    @Column(length=100)
    private String orderNo;
    @Column(length=100)
    private String orderId;
    private Date policyStartDate;
    private Date policyEndDate;
    @Column(scale=2)
    private BigDecimal price;
    private String insureName;
    private String holderName;
    @Column(length=36, name="user_id", nullable=false, updatable=false)
    private String userId;

    public String getUserId() {
        if (this.userId != null && !"".equals(this.userId.trim())) {
            return this.userId;
        }
        return this.member.getCoreUser().getId();
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

