/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.model.shop;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import sinosoftgz.member.model.shop.Member;
import sinosoftgz.utils.jpa.BaseDomain;

@Entity
@Table
public class MemberViewHis
extends BaseDomain
implements Serializable {
    public static final String VIEHISTORY_TYPE_ARTICLE_ID = "ARTICLE_ID";
    public static final String VIEHISTORY_TYPE_PRODUCT_ID = "PRODUCT_ID";
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36, updatable=false)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="member_id", foreignKey=@ForeignKey(name="fk_m_view_his_m_id"))
    private Member member;
    @Column(length=10)
    private String type;
    @Column(length=36, name="target_id")
    private String targetId;
    @Column(length=36, name="user_id", nullable=false, updatable=false)
    private String userId;

    public MemberViewHis(Member member, String type, String targetId) {
        this.member = member;
        this.type = type;
        this.targetId = targetId;
    }

    public MemberViewHis() {
    }

    public String getUserId() {
        if (this.userId != null && !"".equals(this.userId.trim())) {
            return this.userId;
        }
        return this.member.getCoreUser().getId();
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberViewHis that = (MemberViewHis)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "MemberViewHis{id='" + this.id + '\'' + ", member=" + this.member + ", type='" + this.type + '\'' + ", targetId='" + this.targetId + '\'' + '}';
    }
}

