/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.policy.api.app.web.insured;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.policy.api.app.utils.RedisSeqGenerrator;
import sinosoftgz.policy.api.service.prpp.PrppService;
import sinosoftgz.policy.model.prpp.PrpPhead;
import sinosoftgz.policy.vo.EdiAhsJsonVO;
import sinosoftgz.policy.vo.EdiCorrectVO;
import sinosoftgz.policy.vo.Header;
import sinosoftgz.policy.vo.correctrequest.Request;
import sinosoftgz.policy.vo.correctresponse.Response;

@Controller
@RequestMapping(value={"/policy-api-app/correct"})
public class CorrectController {
    private static final String correct = "01";
    private static final String correctAdd = "02";
    private static final String correctRemove = "03";
    @Autowired
    private RedisSeqGenerrator redisSeqGenerrator;
    @Autowired
    private PrppService prppService;

    @RequestMapping(path={"group"}, method={RequestMethod.POST})
    @ResponseBody
    public String groupPolicy(@RequestBody EdiCorrectVO ediCorrectVO) {
        Header header = ediCorrectVO.getHeader();
        Request request = ediCorrectVO.getRequest();
        String endorseNo = this.redisSeqGenerrator.getSeq(request.getPolicyNo() + "-", 2, 1);
        PrpPhead prpPhead = this.getPrpPhead(ediCorrectVO, endorseNo);
        return null;
    }

    @RequestMapping(path={"personnel"}, method={RequestMethod.POST})
    @ResponseBody
    public String personnelPolicy(@RequestBody EdiAhsJsonVO ediAhsJsonVO) {
        String policyNo = "P222211111201700000015";
        String endorseNo = this.redisSeqGenerrator.getSeq(policyNo + "-", 2, 1);
        this.prppService.updateCorrectPersonnelData(ediAhsJsonVO, policyNo, endorseNo);
        return null;
    }

    private Object getResponse(EdiAhsJsonVO ediAhsJsonVO, String policyNo) {
        EdiCorrectVO ediCorrectVOResponse = new EdiCorrectVO();
        Header responseHeader = ediAhsJsonVO.getHeader();
        responseHeader.setResponseCode(Header.STATUS_CODE_SUCCESS);
        responseHeader.setResponseMessage("\u6210\u529f");
        ediCorrectVOResponse.setHeader(responseHeader);
        Response response = new Response();
        response.setPolicyNo(policyNo);
        ediCorrectVOResponse.setResponse(response);
        return ediCorrectVOResponse;
    }

    private PrpPhead getPrpPhead(EdiCorrectVO ediCorrectVO, String endorseNo) {
        Request request = ediCorrectVO.getRequest();
        PrpPhead prpPhead = new PrpPhead();
        BeanUtils.copyProperties((Object)request, (Object)prpPhead);
        prpPhead.setEndorseNo(endorseNo);
        return prpPhead;
    }
}

