/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.policy.api.app.web.insured;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.policy.api.app.utils.RedisSeqGenerrator;
import sinosoftgz.policy.api.service.prpc.PrpcInsuredNatureService;
import sinosoftgz.policy.api.service.prpc.PrpcInsuredService;
import sinosoftgz.policy.api.service.prpc.PrpcMainService;
import sinosoftgz.policy.model.prpc.PrpcEngage;
import sinosoftgz.policy.model.prpc.PrpcInsured;
import sinosoftgz.policy.model.prpc.PrpcInsuredIdvList;
import sinosoftgz.policy.model.prpc.PrpcInsuredIdvListNature;
import sinosoftgz.policy.model.prpc.PrpcInsuredNature;
import sinosoftgz.policy.model.prpc.PrpcItemKind;
import sinosoftgz.policy.model.prpc.PrpcMain;
import sinosoftgz.policy.model.prpd.PrpDcstP;
import sinosoftgz.policy.vo.EdiAhsJsonVO;
import sinosoftgz.policy.vo.Header;
import sinosoftgz.policy.vo.nofeerequest.AhsPolicy;
import sinosoftgz.policy.vo.nofeerequest.DutyInfo;
import sinosoftgz.policy.vo.nofeerequest.EngageInfo;
import sinosoftgz.policy.vo.nofeerequest.GroupPersonnelInfo;
import sinosoftgz.policy.vo.nofeerequest.IndividualPersonnelInfo;
import sinosoftgz.policy.vo.nofeerequest.InsurantInfo;
import sinosoftgz.policy.vo.nofeerequest.PlanInfo;
import sinosoftgz.policy.vo.nofeerequest.PolicyBaseInfo;
import sinosoftgz.policy.vo.nofeerequest.SubjectInfo;
import sinosoftgz.policy.vo.nofeeresponse.PolicyInfo;
import sinosoftgz.policy.vo.nofeeresponse.Response;
import sinosoftgz.utils.data.DateUtils;

@Controller
@RequestMapping(value={"/policy-api-app/insured"})
public class InsuredController {
    private static final String insurePerson = "01";
    private static final String insuredPerson = "02";
    private static final Logger logger = LoggerFactory.getLogger(InsuredController.class);
    @Autowired
    private RedisSeqGenerrator redisSeqGenerrator;
    @Autowired
    private PrpcMainService prpcMainService;
    @Autowired
    private PrpcInsuredService prpcInsuredService;
    @Autowired
    private PrpcInsuredNatureService prpcInsuredNatureService;

    @RequestMapping(value={"/"})
    @ResponseBody
    public String insured(HttpServletRequest request, HttpServletResponse response) {
        String str = null;
        try {
            str = this.getRequestContent(request);
            logger.debug("b2c\u63a5\u53e3\u6536\u5230\u62a5\u6587:{}", (Object)str);
            if (StringUtils.isBlank((CharSequence)str)) {
                response.setCharacterEncoding("UTF-8");
                response.setHeader("Content-Type", "text/html;charset=utf-8");
                response.getWriter().write("\u8bf7\u6c42\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a");
                response.getWriter().flush();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        JSONObject jsonObject = JSON.parseObject((String)str);
        EdiAhsJsonVO ediAhsJsonVO = (EdiAhsJsonVO)JSON.toJavaObject((JSON)jsonObject, EdiAhsJsonVO.class);
        String dutyAmount = "100000";
        String dutyPremium = "0.0";
        List subjectInfoList = ediAhsJsonVO.getRequest().getAhsPolicy().getSubjectInfoList();
        for (SubjectInfo subjectInfo : subjectInfoList) {
            List planInfoList = subjectInfo.getPlanInfoList();
            for (PlanInfo planInfo : planInfoList) {
                List dutyInfoList = planInfo.getDutyInfoList();
                for (DutyInfo dutyInfo : dutyInfoList) {
                    if (!dutyAmount.equals(dutyInfo.getAmount())) {
                        return "\u603b\u4fdd\u989d\u9519\u8bef";
                    }
                    if (dutyPremium.equals(dutyInfo.getPremium())) continue;
                    return "\u603b\u4fdd\u8d39\u9519\u8bef";
                }
            }
        }
        Header header = ediAhsJsonVO.getHeader();
        String comCode = header.getComCode();
        String riskCode = header.getRiskCode();
        String keyApplyPolicyNo = "T" + comCode + riskCode + Calendar.getInstance().get(1);
        String applyPolicyNo = this.redisSeqGenerrator.getSeq(keyApplyPolicyNo, 8, 1);
        String keyPolicyNo = "P" + comCode + riskCode + Calendar.getInstance().get(1);
        String policyNo = this.redisSeqGenerrator.getSeq(keyPolicyNo, 8, 1);
        PrpcMain prpcMain = this.getPrpCmain(ediAhsJsonVO, applyPolicyNo, policyNo);
        PrpcInsured prpcInsuredInsurePerson = null;
        PrpcInsuredNature prpcInsuredNatureInsurePerson = null;
        PrpcInsuredIdvList prpcInsuredIdvList = null;
        if ("1".equals(prpcMain.getPolicyType())) {
            prpcInsuredInsurePerson = this.getPrpcInsured(ediAhsJsonVO, null, applyPolicyNo, insurePerson);
            if ("1".equals(prpcInsuredInsurePerson.getInsuredNature())) {
                prpcInsuredNatureInsurePerson = this.getPrpcInsuredNature(ediAhsJsonVO, null, applyPolicyNo, prpcInsuredInsurePerson.getInsuredFlag());
            }
        } else {
            prpcInsuredIdvList = this.getPrpcInsuredIdvList(ediAhsJsonVO, null, applyPolicyNo, insurePerson);
        }
        ArrayList prpcInsuredList = new ArrayList();
        ArrayList prpcInsuredNatureList = new ArrayList();
        ArrayList prpcInsuredIdvListList = new ArrayList();
        ArrayList prpcInsuredIdvListNatureList = new ArrayList();
        if ("1".equals(prpcMain.getPolicyType())) {
            this.setPrpcInsuredsAndPrpcInsuredNatures(ediAhsJsonVO, applyPolicyNo, prpcInsuredList, prpcInsuredNatureList);
        } else if ("2".equals(prpcMain.getPolicyType())) {
            this.setPrpcInsuredIdvListsAndPrpcInsuredIdvListNatures(ediAhsJsonVO, applyPolicyNo, prpcInsuredIdvListList, prpcInsuredIdvListNatureList);
        }
        ArrayList prpcItemKindList = new ArrayList();
        ArrayList prpcEngageList = new ArrayList();
        this.setPrpcItemKindsAndPrpcEngages(ediAhsJsonVO, applyPolicyNo, prpcItemKindList, prpcEngageList);
        ArrayList prpDcstPList = new ArrayList();
        this.setPrpDcstPs(ediAhsJsonVO, prpDcstPList);
        this.prpcMainService.savePrpc(prpcMain, prpcInsuredInsurePerson, prpcInsuredNatureInsurePerson, prpcInsuredIdvList, prpcInsuredList, prpcInsuredNatureList, prpcInsuredIdvListList, prpcItemKindList, prpcEngageList);
        String responseStr = this.getResponse(ediAhsJsonVO, applyPolicyNo, policyNo);
        return responseStr;
    }

    private void setPrpDcstPs(EdiAhsJsonVO ediAhsJsonVO, List<PrpDcstP> prpDcstPList) {
    }

    private void setPrpcInsuredIdvListsAndPrpcInsuredIdvListNatures(EdiAhsJsonVO ediAhsJsonVO, String applyPolicyNo, List<PrpcInsuredIdvList> prpcInsuredIdvListList, List<PrpcInsuredIdvListNature> prpcInsuredIdvListNatureList) {
        List subjectInfoList = ediAhsJsonVO.getRequest().getAhsPolicy().getSubjectInfoList();
        for (SubjectInfo subjectInfo : subjectInfoList) {
            List insurantInfoList = subjectInfo.getInsurantInfoList();
            for (InsurantInfo insurantInfo : insurantInfoList) {
                PrpcInsuredIdvList prpcInsuredIdvList = this.getPrpcInsuredIdvList(ediAhsJsonVO, insurantInfo, applyPolicyNo, insuredPerson);
                prpcInsuredIdvListList.add(prpcInsuredIdvList);
            }
        }
    }

    private void setPrpcInsuredsAndPrpcInsuredNatures(EdiAhsJsonVO ediAhsJsonVO, String applyPolicyNo, List<PrpcInsured> prpcInsuredList, List<PrpcInsuredNature> prpcInsuredNatureList) {
        List subjectInfoList = ediAhsJsonVO.getRequest().getAhsPolicy().getSubjectInfoList();
        for (SubjectInfo subjectInfo : subjectInfoList) {
            List insurantInfoList = subjectInfo.getInsurantInfoList();
            for (InsurantInfo insurantInfo : insurantInfoList) {
                PrpcInsured prpcInsured = this.getPrpcInsured(ediAhsJsonVO, insurantInfo, applyPolicyNo, insuredPerson);
                prpcInsuredList.add(prpcInsured);
                PrpcInsuredNature prpcInsuredNature = this.getPrpcInsuredNature(ediAhsJsonVO, insurantInfo, applyPolicyNo, insuredPerson);
                prpcInsuredNatureList.add(prpcInsuredNature);
            }
        }
    }

    private void setPrpcItemKindsAndPrpcEngages(EdiAhsJsonVO ediAhsJsonVO, String applyPolicyNo, List<PrpcItemKind> prpcItemKindList, List<PrpcEngage> prpcEngageList) {
        Header header = ediAhsJsonVO.getHeader();
        List subjectInfoList = ediAhsJsonVO.getRequest().getAhsPolicy().getSubjectInfoList();
        for (SubjectInfo subjectInfo : subjectInfoList) {
            List planInfoList = subjectInfo.getPlanInfoList();
            for (PlanInfo planInfo : planInfoList) {
                List dutyInfoList = planInfo.getDutyInfoList();
                for (DutyInfo dutyInfo : dutyInfoList) {
                    PrpcItemKind prpcItemKind = new PrpcItemKind();
                    prpcItemKind.setProposalNo(applyPolicyNo);
                    prpcItemKind.setRiskCode(header.getRiskCode());
                    prpcItemKind.setProductCode(planInfo.getProductCode());
                    prpcItemKind.setProductName(planInfo.getProductName());
                    prpcItemKind.setProjectCode(planInfo.getProjectCode());
                    prpcItemKind.setProjectName(planInfo.getProjectName());
                    prpcItemKind.setAmount(new BigDecimal(planInfo.getAmount()));
                    prpcItemKind.setKindName(dutyInfo.getKindName());
                    prpcItemKind.setKindCode(dutyInfo.getKindCode());
                    prpcItemKind.setPremium(new BigDecimal(dutyInfo.getPremium()));
                    prpcItemKind.setAmount(new BigDecimal(dutyInfo.getAmount()));
                    prpcItemKind.setRate(new BigDecimal(dutyInfo.getRate()));
                    prpcItemKindList.add(prpcItemKind);
                }
                List engageInfoList = planInfo.getEngageInfoList();
                for (EngageInfo engageInfo : engageInfoList) {
                    PrpcEngage prpcEngage = new PrpcEngage();
                    prpcEngage.setProposalNo(applyPolicyNo);
                    prpcEngage.setRiskCode(header.getRiskCode());
                    prpcEngage.setProductCode(planInfo.getProductCode());
                    prpcEngage.setEngageCode(engageInfo.getEngageCode());
                    prpcEngage.setEngageName(engageInfo.getEngageName());
                    prpcEngage.setEngages(engageInfo.getEngages());
                    prpcEngageList.add(prpcEngage);
                }
            }
        }
    }

    private PrpcInsuredIdvList getPrpcInsuredIdvList(EdiAhsJsonVO ediAhsJsonVO, InsurantInfo insurantInfo, String applyPolicyNo, String insuredFlag) {
        Header header = ediAhsJsonVO.getHeader();
        PrpcInsuredIdvList prpcInsuredIdvList = new PrpcInsuredIdvList();
        prpcInsuredIdvList.setProposalNo(applyPolicyNo);
        if (insurePerson.equals(insuredFlag)) {
            GroupPersonnelInfo groupPersonnelInfo = ediAhsJsonVO.getRequest().getAhsPolicy().getInsuranceApplicantInfo().getGroupPersonnelInfo();
            prpcInsuredIdvList.setInsuredFlag(insuredFlag);
            prpcInsuredIdvList.setInsuredCname(groupPersonnelInfo.getGroupName());
            prpcInsuredIdvList.setInsuredIdentity(ediAhsJsonVO.getRequest().getAhsPolicy().getPolicyBaseInfo().getInsuredIdentity());
            prpcInsuredIdvList.setIdentifyType(groupPersonnelInfo.getIdentifyType());
            prpcInsuredIdvList.setIdentifyNumber(groupPersonnelInfo.getIdentifyNumber());
            prpcInsuredIdvList.setBank(groupPersonnelInfo.getBank());
            prpcInsuredIdvList.setAccount(groupPersonnelInfo.getAccount());
            prpcInsuredIdvList.setPostAddress(groupPersonnelInfo.getPostAddress());
            prpcInsuredIdvList.setSex(groupPersonnelInfo.getSex());
            prpcInsuredIdvList.setLinkerName(groupPersonnelInfo.getLinkerName());
            prpcInsuredIdvList.setMobile(groupPersonnelInfo.getMobile());
            prpcInsuredIdvList.setPostCode(groupPersonnelInfo.getPostCode());
            prpcInsuredIdvList.setEmail(groupPersonnelInfo.getEmail());
        }
        return prpcInsuredIdvList;
    }

    private PrpcInsuredNature getPrpcInsuredNature(EdiAhsJsonVO ediAhsJsonVO, InsurantInfo insurantInfo, String applyPolicyNo, String insuredFlag) {
        Header header = ediAhsJsonVO.getHeader();
        PrpcInsuredNature prpcInsuredNature = new PrpcInsuredNature();
        prpcInsuredNature.setProposalNo(applyPolicyNo);
        if (insurePerson.equals(insuredFlag)) {
            IndividualPersonnelInfo individualPersonnelInfo = ediAhsJsonVO.getRequest().getAhsPolicy().getInsuranceApplicantInfo().getIndividualPersonnelInfo();
            prpcInsuredNature.setInsuredFlag(insuredFlag);
            prpcInsuredNature.setSex(individualPersonnelInfo.getSex());
            prpcInsuredNature.setAge(Integer.valueOf(Integer.parseInt(individualPersonnelInfo.getAge())));
            prpcInsuredNature.setBirthday(DateUtils.toDate((String)individualPersonnelInfo.getBirthday(), (String)"yyyy-MM-dd"));
        } else if (insuredPerson.equals(insuredFlag)) {
            prpcInsuredNature.setInsuredFlag(insuredFlag);
            prpcInsuredNature.setSex(insurantInfo.getSex());
            prpcInsuredNature.setAge(Integer.valueOf(Integer.parseInt(insurantInfo.getAge())));
            prpcInsuredNature.setBirthday(DateUtils.toDate((String)insurantInfo.getBirthday(), (String)"yyyy-MM-dd"));
        }
        return prpcInsuredNature;
    }

    private PrpcInsured getPrpcInsured(EdiAhsJsonVO ediAhsJsonVO, InsurantInfo insurantInfo, String applyPolicyNo, String insuredFlag) {
        Header header = ediAhsJsonVO.getHeader();
        PrpcInsured prpcInsured = new PrpcInsured();
        prpcInsured.setProposalNo(applyPolicyNo);
        prpcInsured.setRiskCode(header.getRiskCode());
        prpcInsured.setInsuredNature("1");
        if (insurePerson.equals(insuredFlag)) {
            IndividualPersonnelInfo individualPersonnelInfo = ediAhsJsonVO.getRequest().getAhsPolicy().getInsuranceApplicantInfo().getIndividualPersonnelInfo();
            prpcInsured.setInsuredName(individualPersonnelInfo.getInsuredName());
            prpcInsured.setInsuredFlag(insuredFlag);
            prpcInsured.setInsuredIdentity(ediAhsJsonVO.getRequest().getAhsPolicy().getPolicyBaseInfo().getInsuredIdentity());
            prpcInsured.setIdentifyType(individualPersonnelInfo.getIdentifyType());
            prpcInsured.setIdentifyNumber(individualPersonnelInfo.getIdentifyNumber());
            prpcInsured.setMobile(individualPersonnelInfo.getMobile());
            prpcInsured.setEmail(individualPersonnelInfo.getEmail());
            prpcInsured.setSex(individualPersonnelInfo.getSex());
            prpcInsured.setAge(Integer.valueOf(Integer.parseInt(individualPersonnelInfo.getAge())));
        } else if (insuredPerson.equals(insuredFlag)) {
            prpcInsured.setInsuredFlag(insuredFlag);
            prpcInsured.setInsuredName(insurantInfo.getInsuredName());
            prpcInsured.setSex(insurantInfo.getSex());
            prpcInsured.setIdentifyType(insurantInfo.getIdentifyType());
            prpcInsured.setIdentifyNumber(insurantInfo.getIdentifyNumber());
            prpcInsured.setMobile(insurantInfo.getMobile());
            prpcInsured.setEmail(insurantInfo.getEmail());
            prpcInsured.setAge(Integer.valueOf(Integer.parseInt(insurantInfo.getAge())));
        }
        return prpcInsured;
    }

    private PrpcMain getPrpCmain(EdiAhsJsonVO ediAhsJsonVO, String applyPolicyNo, String policyNo) {
        Header header = ediAhsJsonVO.getHeader();
        AhsPolicy ahsPolicy = ediAhsJsonVO.getRequest().getAhsPolicy();
        PolicyBaseInfo policyBaseInfo = ahsPolicy.getPolicyBaseInfo();
        PrpcMain prpcMain = new PrpcMain();
        prpcMain.setProposalNo(applyPolicyNo);
        prpcMain.setPolicyNo(policyNo);
        prpcMain.setClassCode(header.getClassCode());
        prpcMain.setRiskCode(header.getRiskCode());
        prpcMain.setPolicyType(policyBaseInfo.getPolicyType());
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            prpcMain.setInputTime(sdfDate.parse(header.getInputTime()));
            prpcMain.setStartDate(sdfDate.parse(policyBaseInfo.getStartDate()));
            prpcMain.setStartHour(Integer.valueOf(this.getHour(sdfDate.parse(policyBaseInfo.getStartDate()))));
            prpcMain.setEndDate(sdfDate.parse(policyBaseInfo.getEndDate()));
            prpcMain.setEndHour(Integer.valueOf(this.getHour(sdfDate.parse(policyBaseInfo.getEndDate()))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        prpcMain.setCurrency(policyBaseInfo.getCurrecy());
        prpcMain.setSumPremium(new BigDecimal(policyBaseInfo.getSumPremium()));
        prpcMain.setInsuredCount(Integer.valueOf(Integer.parseInt(policyBaseInfo.getInsuredCount())));
        prpcMain.setComCode(header.getComCode());
        prpcMain.setAgentCode(header.getAgentCode());
        prpcMain.setJfeeFlag(policyBaseInfo.getJfeeFlag());
        return prpcMain;
    }

    private int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    private String getResponse(EdiAhsJsonVO ediAhsJsonVO, String applyPolicyNo, String policyNo) {
        EdiAhsJsonVO ediAhsJsonVOResponse = new EdiAhsJsonVO();
        PolicyInfo policyInfo = new PolicyInfo();
        policyInfo.setProposalNo(applyPolicyNo);
        policyInfo.setPolicyNo(policyNo);
        policyInfo.setSumPremium(ediAhsJsonVO.getRequest().getAhsPolicy().getPolicyBaseInfo().getSumPremium());
        Header responseHeader = ediAhsJsonVO.getHeader();
        responseHeader.setResponseCode(Header.STATUS_CODE_SUCCESS);
        responseHeader.setResponseMessage("\u6210\u529f");
        ediAhsJsonVOResponse.setHeader(responseHeader);
        ediAhsJsonVOResponse.setResponse(new Response(policyInfo));
        return JSON.toJSONString((Object)ediAhsJsonVOResponse, (boolean)false);
    }

    private String getRequestContent(HttpServletRequest request) throws IOException {
        String str = null;
        ServletInputStream sis = request.getInputStream();
        int size = request.getContentLength();
        byte[] buffer = new byte[size];
        byte[] xmldataByte = new byte[size];
        int rbyte = 0;
        for (int count = 0; count < size; count += rbyte) {
            rbyte = sis.read(buffer);
            for (int i = 0; i < rbyte; ++i) {
                xmldataByte[count + i] = buffer[i];
            }
        }
        str = new String(xmldataByte, "UTF-8");
        if (logger.isInfoEnabled()) {
            logger.info("\u63a5\u6536\u5230\u62a5\u6587 \uff1a {}", (Object)str);
        }
        return str;
    }
}

