/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.policy.api.app.web.insured;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sinosoftgz.drools.vo.RuleVo;
import sinosoftgz.policy.api.app.utils.RedisSeqGenerrator;
import sinosoftgz.policy.api.service.api.PolicyApiImpl;
import sinosoftgz.policy.api.service.api.PremiumApiImpl;
import sinosoftgz.policy.api.service.rule.service.CommonDataCheckRuleService;
import sinosoftgz.policy.api.service.rule.service.RiskDataCheckRuleService;
import sinosoftgz.policy.api.vo.PolicyVo;
import sinosoftgz.policy.model.prpc.PrpcMain;
import sinosoftgz.policy.vo.EdiAhsJsonVO;
import sinosoftgz.policy.vo.Header;
import sinosoftgz.policy.vo.nofeerequest.AhsPolicy;
import sinosoftgz.policy.vo.nofeerequest.PolicyBaseInfo;

@Controller
@RequestMapping(value={"/policy-api-app"})
public class PolicyApiController {
    @Autowired
    PolicyApiImpl policyApi;
    @Autowired
    PremiumApiImpl premiumApi;
    @Autowired
    CommonDataCheckRuleService commonDataCheckRuleService;
    @Autowired
    RiskDataCheckRuleService riskDataCheckRuleService;
    @Autowired
    private RedisSeqGenerrator redisSeqGenerrator;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Object tip() {
        HashMap map = Maps.newHashMap();
        map.put("message", "\u4fdd\u5355\u670d\u52a1");
        return map;
    }

    @RequestMapping(path={"createPolicy"}, method={RequestMethod.POST})
    @ResponseBody
    public Object createPolicy(@RequestBody PolicyVo policyVo) {
        PolicyVo policyVo1 = this.policyApi.createPolicy(policyVo);
        return policyVo1;
    }

    @RequestMapping(path={"insuranceCalculation"}, method={RequestMethod.POST})
    @ResponseBody
    public Object insuranceCalculation(@RequestBody EdiAhsJsonVO ediAhsJsonVO) {
        Header header = ediAhsJsonVO.getHeader();
        String comCode = header.getComCode();
        String riskCode = header.getRiskCode();
        String keyApplyPolicyNo = "T" + comCode + riskCode + Calendar.getInstance().get(1);
        String applyPolicyNo = this.redisSeqGenerrator.getSeq(keyApplyPolicyNo, 8, 1);
        String keyPolicyNo = "P" + comCode + riskCode + Calendar.getInstance().get(1);
        String policyNo = this.redisSeqGenerrator.getSeq(keyPolicyNo, 8, 1);
        PrpcMain prpcMain = this.getPrpCmain(ediAhsJsonVO, applyPolicyNo, policyNo);
        PolicyVo policyVo = new PolicyVo();
        BeanUtils.copyProperties((Object)prpcMain, (Object)policyVo);
        PolicyVo policyVo1 = this.premiumApi.calculate(policyVo);
        return policyVo1;
    }

    @RequestMapping(path={"dataCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public Object dataCheck(@RequestBody PolicyVo policyVo) {
        RuleVo prpCmainRuleVo = new RuleVo();
        prpCmainRuleVo.setBusinessObj((Object)policyVo);
        this.commonDataCheckRuleService.check(prpCmainRuleVo);
        if (prpCmainRuleVo.isBusinessSuccessFlag()) {
            this.riskDataCheckRuleService.check(prpCmainRuleVo);
        }
        return policyVo;
    }

    private PrpcMain getPrpCmain(EdiAhsJsonVO ediAhsJsonVO, String applyPolicyNo, String policyNo) {
        Header header = ediAhsJsonVO.getHeader();
        AhsPolicy ahsPolicy = ediAhsJsonVO.getRequest().getAhsPolicy();
        PolicyBaseInfo policyBaseInfo = ahsPolicy.getPolicyBaseInfo();
        PrpcMain prpcMain = new PrpcMain();
        prpcMain.setProposalNo(applyPolicyNo);
        prpcMain.setPolicyNo(policyNo);
        prpcMain.setClassCode(header.getClassCode());
        prpcMain.setRiskCode(header.getRiskCode());
        prpcMain.setPolicyType(policyBaseInfo.getPolicyType());
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            prpcMain.setInputTime(sdfDate.parse(header.getInputTime()));
            prpcMain.setStartDate(sdfDate.parse(policyBaseInfo.getStartDate()));
            prpcMain.setStartHour(Integer.valueOf(this.getHour(sdfDate.parse(policyBaseInfo.getStartDate()))));
            prpcMain.setEndDate(sdfDate.parse(policyBaseInfo.getEndDate()));
            prpcMain.setEndHour(Integer.valueOf(this.getHour(sdfDate.parse(policyBaseInfo.getEndDate()))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        prpcMain.setCurrency(policyBaseInfo.getCurrecy());
        prpcMain.setSumPremium(new BigDecimal(policyBaseInfo.getSumPremium()));
        prpcMain.setInsuredCount(Integer.valueOf(Integer.parseInt(policyBaseInfo.getInsuredCount())));
        prpcMain.setComCode(header.getComCode());
        prpcMain.setAgentCode(header.getAgentCode());
        prpcMain.setJfeeFlag(policyBaseInfo.getJfeeFlag());
        return prpcMain;
    }

    private int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }
}

